% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/options.R
\docType{data}
\name{r2spss_options}
\alias{r2spss_options}
\title{Options for package r2spss}
\format{
A list with the following two components:
\describe{
  \item{\code{get(which, drop = TRUE)}}{an accessor function to retrieve
  current options, which are usually returned as a named list.  Argument
  \code{which} allows to select which options to retrieve.  If a single
  option is selected, argument \code{drop} indicates whether only its value
  should be returned (\code{TRUE}) or a list of length one (\code{FALSE}).}
  \item{\code{set(...)}}{an accessor function to set certain options using
  \code{name = value} pairs.}
}
}
\usage{
r2spss_options
}
\description{
Retrieve or set global options for package \pkg{r2spss} (within the current
\R session) via accessor functions.
}
\details{
Currently, the only available option is \code{version}, which controls
tables and plots should mimic the content and look of recent SPSS versions
(\code{"modern"}) or older versions (<24; \code{"legacy"}).
}
\examples{
# retrieve list of options:
r2spss_options$get()

# retrieve a single option:
r2spss_options$get("version")

\dontrun{

# set an option:
r2spss_options$set(version = "legacy")
}

}
\author{
Andreas Alfons
}
\keyword{utilities}
