% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/decoration.R
\name{decorate.xgb.Booster}
\alias{decorate.xgb.Booster}
\title{Decorates an "xgb.Booster" object with "fmap", "schema", "ntreelimit" and "pmml_options" elements.}
\usage{
\method{decorate}{xgb.Booster}(
  x,
  fmap,
  response_name = NULL,
  response_levels = c(),
  missing = NULL,
  ntreelimit = NULL,
  compact = FALSE,
  ...
)
}
\arguments{
\item{x}{An "xgb.Booster" object.}

\item{fmap}{An XGBoost feature map as a "data.frame" object.}

\item{response_name}{The name of the target field.}

\item{response_levels}{A list of category values for a categorical target field.}

\item{missing}{The string representation of missing input field values.}

\item{ntreelimit}{The number of decision trees (aka boosting rounds) to convert.}

\item{compact}{A flag controlling if decision trees should be transformed from binary splits (FALSE) to multi-way splits (TRUE) representation.}

\item{...}{Arguments to pass on to the "decorate.default" function.}
}
\description{
Decorates an "xgb.Booster" object with "fmap", "schema", "ntreelimit" and "pmml_options" elements.
}
\examples{
\donttest{
library("xgboost")
library("r2pmml")

data(iris)
iris_X = iris[, -ncol(iris)]
iris_y = iris[, ncol(iris)]
# Convert from factor to integer[0, num_class]
iris_y = (as.integer(iris_y) - 1)
iris.matrix = model.matrix(~ . - 1, data = iris_X)
iris.DMatrix = xgb.DMatrix(iris.matrix, label = iris_y)
iris.fmap = as.fmap(iris.matrix)
iris.xgboost = xgboost(data = iris.DMatrix,
    objective = "multi:softprob", num_class = 3, nrounds = 11)
iris.xgboost = decorate(iris.xgboost, iris.fmap, 
    response_name = "Species", response_levels = c("setosa", "versicolor", "virginica"))
pmmlFile = file.path(tempdir(), "Iris-XGBoost.pmml")
r2pmml(iris.xgboost, pmmlFile, compact = FALSE)
compactPmmlFile = file.path(tempdir(), "Iris-XGBoost-compact.pmml")
r2pmml(iris.xgboost, compactPmmlFile, compact = TRUE)
}
}
