/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.rexp;

import java.util.ArrayList;
import java.util.List;
import org.dmg.pmml.Apply;
import org.dmg.pmml.Constant;
import org.dmg.pmml.DataType;
import org.dmg.pmml.Expression;
import org.dmg.pmml.FieldName;
import org.dmg.pmml.FieldRef;
import org.dmg.pmml.Interval;
import org.dmg.pmml.Visitable;
import org.jpmml.converter.visitors.ExpressionCompactor;
import org.jpmml.rexp.ExpressionTranslatorConstants;
import org.jpmml.rexp.ExpressionTranslatorTokenManager;
import org.jpmml.rexp.FunctionExpression;
import org.jpmml.rexp.ParseException;
import org.jpmml.rexp.Provider;
import org.jpmml.rexp.SimpleCharStream;
import org.jpmml.rexp.StringProvider;
import org.jpmml.rexp.Token;
import org.jpmml.rexp.TokenMgrException;

public class ExpressionTranslator
implements ExpressionTranslatorConstants {
    public ExpressionTranslatorTokenManager token_source;
    SimpleCharStream jj_input_stream;
    public Token token;
    public Token jj_nt;
    private int jj_ntk;
    private Token jj_scanpos;
    private Token jj_lastpos;
    private int jj_la;
    private int jj_gen;
    private final int[] jj_la1 = new int[27];
    private static int[] jj_la1_0;
    private static int[] jj_la1_1;
    private final JJCalls[] jj_2_rtns = new JJCalls[7];
    private boolean jj_rescan = false;
    private int jj_gc = 0;
    private final LookaheadSuccess jj_ls = new LookaheadSuccess();
    private List<int[]> jj_expentries = new ArrayList<int[]>();
    private int[] jj_expentry;
    private int jj_kind = -1;
    private int[] jj_lasttokens = new int[100];
    private int jj_endpos;

    public static Expression translateExpression(String string) {
        return ExpressionTranslator.translateExpression(string, true);
    }

    public static Expression translateExpression(String string, boolean compact) {
        Expression expression;
        try {
            ExpressionTranslator translator = new ExpressionTranslator(string);
            expression = translator.translateExpressionInternal();
        }
        catch (ParseException pe) {
            throw new IllegalArgumentException(string, pe);
        }
        if (compact) {
            ExpressionCompactor compactor = new ExpressionCompactor();
            compactor.applyTo((Visitable)expression);
        }
        return expression;
    }

    public static Interval translateInterval(String string) {
        Interval interval;
        try {
            ExpressionTranslator translator = new ExpressionTranslator(string);
            interval = translator.translateIntervalInternal();
        }
        catch (ParseException pe) {
            throw new IllegalArgumentException(string, pe);
        }
        return interval;
    }

    private static String translateFunction(String function) {
        switch (function) {
            case "abs": {
                return function;
            }
            case "ceiling": {
                return "ceil";
            }
            case "exp": 
            case "floor": {
                return function;
            }
            case "log": {
                return "ln";
            }
            case "log10": 
            case "round": 
            case "sqrt": {
                return function;
            }
        }
        switch (function) {
            case "is.na": {
                return "isMissing";
            }
        }
        throw new IllegalArgumentException(function);
    }

    private static String translateLogicalOperator(String operator) {
        switch (operator) {
            case "&": {
                return "and";
            }
            case "|": {
                return "or";
            }
        }
        throw new IllegalArgumentException(operator);
    }

    private static String translateRelationalOperator(String operator) {
        switch (operator) {
            case "==": {
                return "equal";
            }
            case "!=": {
                return "notEqual";
            }
            case "<": {
                return "lessThan";
            }
            case "<=": {
                return "lessOrEqual";
            }
            case ">": {
                return "greaterThan";
            }
            case ">=": {
                return "greaterOrEqual";
            }
        }
        throw new IllegalArgumentException(operator);
    }

    private static Interval.Closure translateClosure(String leftBound, String rightBound) {
        String closure;
        switch (closure = leftBound + rightBound) {
            case "()": {
                return Interval.Closure.OPEN_OPEN;
            }
            case "(]": {
                return Interval.Closure.OPEN_CLOSED;
            }
            case "[)": {
                return Interval.Closure.CLOSED_OPEN;
            }
            case "[]": {
                return Interval.Closure.CLOSED_CLOSED;
            }
        }
        throw new IllegalArgumentException(closure);
    }

    private static String translateValue(Token value) {
        String image = value.image;
        switch (value.kind) {
            case 35: 
            case 44: {
                return image.toLowerCase();
            }
            case 36: {
                return "Infinity";
            }
            case 42: {
                return "NaN";
            }
            case 48: {
                return image.substring(1, image.length() - 1);
            }
        }
        return image;
    }

    private static String translateTag(Token tag) {
        String image = tag.image;
        switch (tag.kind) {
            case 47: {
                return image;
            }
            case 48: {
                return image.substring(1, image.length() - 1);
            }
        }
        throw new IllegalArgumentException();
    }

    private static Apply createApply(String function, Expression ... expressions) {
        Apply apply = new Apply(function);
        for (Expression expression : expressions) {
            apply.addExpressions(new Expression[]{expression});
        }
        return apply;
    }

    private static Double filterMargin(Double value) {
        if (value.isNaN()) {
            throw new IllegalArgumentException();
        }
        if (value.isInfinite()) {
            return null;
        }
        return value;
    }

    private final Expression translateExpressionInternal() throws ParseException {
        Expression expression = this.Expression();
        this.jj_consume_token(0);
        return expression;
    }

    public final Expression Expression() throws ParseException {
        Expression expression;
        if (this.jj_2_1(Integer.MAX_VALUE)) {
            expression = this.IfExpression();
        } else {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 5: 
                case 9: 
                case 10: 
                case 15: 
                case 35: 
                case 36: 
                case 42: 
                case 44: 
                case 45: 
                case 46: 
                case 47: 
                case 48: {
                    expression = this.OrExpression();
                    break;
                }
                default: {
                    this.jj_la1[0] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
        }
        return expression;
    }

    public final Expression IfExpression() throws ParseException {
        Expression second = null;
        this.jj_consume_token(30);
        this.jj_consume_token(5);
        Expression condition = this.Expression();
        this.jj_consume_token(6);
        Expression first = this.Expression();
        if (this.jj_2_2(Integer.MAX_VALUE)) {
            this.jj_consume_token(29);
            second = this.Expression();
        }
        if (second != null) {
            return ExpressionTranslator.createApply("if", condition, first, second);
        }
        return ExpressionTranslator.createApply("if", condition, first);
    }

    public final Expression OrExpression() throws ParseException {
        Expression left = this.AndExpression();
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 14: {
                    break;
                }
                default: {
                    this.jj_la1[1] = this.jj_gen;
                    break block3;
                }
            }
            Token operator = this.jj_consume_token(14);
            Expression right = this.AndExpression();
            left = ExpressionTranslator.createApply(ExpressionTranslator.translateLogicalOperator(operator.image), left, right);
        }
        return left;
    }

    public final Expression AndExpression() throws ParseException {
        Expression left = this.NegationExpression();
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 13: {
                    break;
                }
                default: {
                    this.jj_la1[2] = this.jj_gen;
                    break block3;
                }
            }
            Token operator = this.jj_consume_token(13);
            Expression right = this.NegationExpression();
            left = ExpressionTranslator.createApply(ExpressionTranslator.translateLogicalOperator(operator.image), left, right);
        }
        return left;
    }

    public final Expression NegationExpression() throws ParseException {
        Token operator = null;
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 15: {
                operator = this.jj_consume_token(15);
                break;
            }
            default: {
                this.jj_la1[3] = this.jj_gen;
            }
        }
        Expression expression = this.RelationalExpression();
        if (operator != null) {
            return ExpressionTranslator.createApply("not", expression);
        }
        return expression;
    }

    public final Expression RelationalExpression() throws ParseException {
        Expression left = this.AdditiveExpression();
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                Token operator;
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 16: {
                        operator = this.jj_consume_token(16);
                        break;
                    }
                    case 17: {
                        operator = this.jj_consume_token(17);
                        break;
                    }
                    case 18: {
                        operator = this.jj_consume_token(18);
                        break;
                    }
                    case 19: {
                        operator = this.jj_consume_token(19);
                        break;
                    }
                    case 20: {
                        operator = this.jj_consume_token(20);
                        break;
                    }
                    case 21: {
                        operator = this.jj_consume_token(21);
                        break;
                    }
                    default: {
                        this.jj_la1[4] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                Expression right = this.AdditiveExpression();
                left = ExpressionTranslator.createApply(ExpressionTranslator.translateRelationalOperator(operator.image), left, right);
                break;
            }
            default: {
                this.jj_la1[5] = this.jj_gen;
            }
        }
        return left;
    }

    public final Expression AdditiveExpression() throws ParseException {
        Expression left = this.MultiplicativeExpression();
        block7: while (true) {
            Token operator;
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 9: 
                case 10: {
                    break;
                }
                default: {
                    this.jj_la1[6] = this.jj_gen;
                    break block7;
                }
            }
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 9: {
                    operator = this.jj_consume_token(9);
                    break;
                }
                case 10: {
                    operator = this.jj_consume_token(10);
                    break;
                }
                default: {
                    this.jj_la1[7] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
            Expression right = this.MultiplicativeExpression();
            left = ExpressionTranslator.createApply(operator.image, left, right);
        }
        return left;
    }

    public final Expression MultiplicativeExpression() throws ParseException {
        Expression left = this.UnaryExpression();
        block7: while (true) {
            Token operator;
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 3: 
                case 4: {
                    break;
                }
                default: {
                    this.jj_la1[8] = this.jj_gen;
                    break block7;
                }
            }
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 3: {
                    operator = this.jj_consume_token(3);
                    break;
                }
                case 4: {
                    operator = this.jj_consume_token(4);
                    break;
                }
                default: {
                    this.jj_la1[9] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
            Expression right = this.UnaryExpression();
            left = ExpressionTranslator.createApply(operator.image, left, right);
        }
        return left;
    }

    public final Expression UnaryExpression() throws ParseException {
        Token sign = null;
        block0 : switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 9: 
            case 10: {
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 9: {
                        sign = this.jj_consume_token(9);
                        break block0;
                    }
                    case 10: {
                        sign = this.jj_consume_token(10);
                        break block0;
                    }
                }
                this.jj_la1[10] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
            default: {
                this.jj_la1[11] = this.jj_gen;
            }
        }
        Expression expression = this.ExponentiationExpression();
        if (sign != null && sign.kind == 10) {
            if (expression instanceof Constant) {
                Constant constant = (Constant)expression;
                constant.setValue((Object)("-" + constant.getValue()));
            } else {
                Constant constant = new Constant().setValue((Object)"-1");
                expression = ExpressionTranslator.createApply("*", new Expression[]{constant, expression});
            }
        }
        return expression;
    }

    public final Expression ExponentiationExpression() throws ParseException {
        Token operator = null;
        Expression right = null;
        Expression left = this.PrimaryExpression();
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 11: 
            case 12: {
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 11: {
                        operator = this.jj_consume_token(11);
                        break;
                    }
                    case 12: {
                        operator = this.jj_consume_token(12);
                        break;
                    }
                    default: {
                        this.jj_la1[12] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                right = this.UnaryExpression();
                left = ExpressionTranslator.createApply("pow", left, right);
                break;
            }
            default: {
                this.jj_la1[13] = this.jj_gen;
            }
        }
        return left;
    }

    public final Expression PrimaryExpression() throws ParseException {
        Expression expression;
        if (this.jj_2_3(Integer.MAX_VALUE)) {
            expression = this.FunctionInvocationExpression();
        } else if (this.jj_2_4(Integer.MAX_VALUE)) {
            expression = this.FunctionInvocationExpression();
        } else {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 47: {
                    expression = this.FieldInvocationExpression();
                    break;
                }
                case 5: {
                    expression = this.ParenthesizedExpression();
                    break;
                }
                case 35: 
                case 36: 
                case 42: 
                case 44: 
                case 45: 
                case 46: 
                case 48: {
                    expression = this.Constant();
                    break;
                }
                default: {
                    this.jj_la1[14] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
        }
        return expression;
    }

    public final Expression FunctionInvocationExpression() throws ParseException {
        Token end;
        List<FunctionExpression.Argument> arguments;
        Token begin;
        Token function;
        Token namespace = null;
        if (this.jj_2_5(Integer.MAX_VALUE)) {
            namespace = this.jj_consume_token(47);
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 24: {
                    this.jj_consume_token(24);
                    break;
                }
                case 25: {
                    this.jj_consume_token(25);
                    break;
                }
                default: {
                    this.jj_la1[15] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
            function = this.jj_consume_token(47);
            begin = this.jj_consume_token(5);
            arguments = this.ArgumentList();
            end = this.jj_consume_token(6);
        } else {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 47: {
                    function = this.jj_consume_token(47);
                    begin = this.jj_consume_token(5);
                    arguments = this.ArgumentList();
                    end = this.jj_consume_token(6);
                    break;
                }
                default: {
                    this.jj_la1[16] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
        }
        if (arguments.size() > 0) {
            FunctionExpression.Argument firstArgument = arguments.get(0);
            firstArgument.setBegin(begin);
            FunctionExpression.Argument lastArgument = arguments.get(arguments.size() - 1);
            lastArgument.setEnd(end);
        }
        try {
            FunctionExpression.Argument argument;
            String pmmlFunction = ExpressionTranslator.translateFunction(function.image);
            if (arguments.size() == 1 && !(argument = arguments.get(0)).hasTag() && !(argument.getExpression() instanceof FunctionExpression)) {
                return ExpressionTranslator.createApply(pmmlFunction, argument.getExpression());
            }
        }
        catch (IllegalArgumentException pmmlFunction) {
            // empty catch block
        }
        FunctionExpression functionExpression = namespace != null ? new FunctionExpression(namespace.image, function.image, arguments) : new FunctionExpression(function.image, arguments);
        return functionExpression;
    }

    private final List<FunctionExpression.Argument> ArgumentList() throws ParseException {
        ArrayList<FunctionExpression.Argument> arguments = new ArrayList<FunctionExpression.Argument>();
        FunctionExpression.Argument argument = this.Argument();
        arguments.add(argument);
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 23: {
                    break;
                }
                default: {
                    this.jj_la1[17] = this.jj_gen;
                    break block3;
                }
            }
            Token comma = this.jj_consume_token(23);
            argument.setEnd(comma);
            argument = this.Argument();
            argument.setBegin(comma);
            arguments.add(argument);
        }
        return arguments;
    }

    private final FunctionExpression.Argument Argument() throws ParseException {
        Expression expression;
        Token tag = null;
        if (this.jj_2_6(Integer.MAX_VALUE)) {
            tag = this.jj_consume_token(47);
            this.jj_consume_token(22);
            expression = this.Expression();
        } else if (this.jj_2_7(Integer.MAX_VALUE)) {
            tag = this.jj_consume_token(48);
            this.jj_consume_token(22);
            expression = this.Expression();
        } else {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 5: 
                case 9: 
                case 10: 
                case 15: 
                case 30: 
                case 35: 
                case 36: 
                case 42: 
                case 44: 
                case 45: 
                case 46: 
                case 47: 
                case 48: {
                    expression = this.Expression();
                    break;
                }
                default: {
                    this.jj_la1[18] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
        }
        FunctionExpression.Argument argument = tag != null ? new FunctionExpression.Argument(ExpressionTranslator.translateTag(tag), expression) : new FunctionExpression.Argument(expression);
        return argument;
    }

    public final FieldRef FieldInvocationExpression() throws ParseException {
        Token name = this.jj_consume_token(47);
        FieldRef fieldRef = new FieldRef().setField(FieldName.create((String)name.image));
        return fieldRef;
    }

    public final Expression ParenthesizedExpression() throws ParseException {
        this.jj_consume_token(5);
        Expression expression = this.Expression();
        this.jj_consume_token(6);
        return expression;
    }

    public final Constant Constant() throws ParseException {
        Token value;
        DataType dataType = null;
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 45: {
                value = this.jj_consume_token(45);
                break;
            }
            case 36: 
            case 42: 
            case 46: {
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 46: {
                        value = this.jj_consume_token(46);
                        break;
                    }
                    case 36: {
                        value = this.jj_consume_token(36);
                        break;
                    }
                    case 42: {
                        value = this.jj_consume_token(42);
                        break;
                    }
                    default: {
                        this.jj_la1[19] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                dataType = DataType.DOUBLE;
                break;
            }
            case 35: 
            case 44: {
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 35: {
                        value = this.jj_consume_token(35);
                        break;
                    }
                    case 44: {
                        value = this.jj_consume_token(44);
                        break;
                    }
                    default: {
                        this.jj_la1[20] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                dataType = DataType.BOOLEAN;
                break;
            }
            case 48: {
                value = this.jj_consume_token(48);
                break;
            }
            default: {
                this.jj_la1[21] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        Constant constant = new Constant().setValue((Object)ExpressionTranslator.translateValue(value)).setDataType(dataType);
        return constant;
    }

    private final Interval translateIntervalInternal() throws ParseException {
        Interval interval = this.Interval();
        this.jj_consume_token(0);
        return interval;
    }

    public final Interval Interval() throws ParseException {
        Token rightBound;
        Token leftBound;
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 5: {
                leftBound = this.jj_consume_token(5);
                break;
            }
            case 7: {
                leftBound = this.jj_consume_token(7);
                break;
            }
            default: {
                this.jj_la1[22] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        Double leftMargin = this.SignedNumber();
        this.jj_consume_token(23);
        Double rightMargin = this.SignedNumber();
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 6: {
                rightBound = this.jj_consume_token(6);
                break;
            }
            case 8: {
                rightBound = this.jj_consume_token(8);
                break;
            }
            default: {
                this.jj_la1[23] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        Interval interval = new Interval(ExpressionTranslator.translateClosure(leftBound.image, rightBound.image)).setLeftMargin(ExpressionTranslator.filterMargin(leftMargin)).setRightMargin(ExpressionTranslator.filterMargin(rightMargin));
        return interval;
    }

    private final Double SignedNumber() throws ParseException {
        Token value;
        Token sign = null;
        block0 : switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 9: 
            case 10: {
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 9: {
                        sign = this.jj_consume_token(9);
                        break block0;
                    }
                    case 10: {
                        sign = this.jj_consume_token(10);
                        break block0;
                    }
                }
                this.jj_la1[24] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
            default: {
                this.jj_la1[25] = this.jj_gen;
            }
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 45: {
                value = this.jj_consume_token(45);
                break;
            }
            case 46: {
                value = this.jj_consume_token(46);
                break;
            }
            case 36: {
                value = this.jj_consume_token(36);
                break;
            }
            case 42: {
                value = this.jj_consume_token(42);
                break;
            }
            default: {
                this.jj_la1[26] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        String javaValue = ExpressionTranslator.translateValue(value);
        if (sign != null && sign.kind == 10) {
            javaValue = "-" + javaValue;
        }
        return Double.valueOf(javaValue);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_1(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_1();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(0, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_2(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_2();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(1, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_3(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_3();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(2, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_4(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_4();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(3, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_5(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_5();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(4, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_6(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_6();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(5, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_7(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_7();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(6, xla);
        }
    }

    private boolean jj_3_3() {
        if (this.jj_scan_token(47)) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_scan_token(24)) {
            this.jj_scanpos = xsp;
            if (this.jj_scan_token(25)) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3_1() {
        return this.jj_scan_token(30);
    }

    private boolean jj_3_7() {
        if (this.jj_scan_token(48)) {
            return true;
        }
        return this.jj_scan_token(22);
    }

    private boolean jj_3_6() {
        if (this.jj_scan_token(47)) {
            return true;
        }
        return this.jj_scan_token(22);
    }

    private boolean jj_3_5() {
        if (this.jj_scan_token(47)) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_scan_token(24)) {
            this.jj_scanpos = xsp;
            if (this.jj_scan_token(25)) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3_4() {
        if (this.jj_scan_token(47)) {
            return true;
        }
        return this.jj_scan_token(5);
    }

    private boolean jj_3_2() {
        return this.jj_scan_token(29);
    }

    private static void jj_la1_init_0() {
        jj_la1_0 = new int[]{34336, 16384, 8192, 32768, 0x3F0000, 0x3F0000, 1536, 1536, 24, 24, 1536, 1536, 6144, 6144, 32, 0x3000000, 0, 0x800000, 1073776160, 0, 0, 0, 160, 320, 1536, 1536, 0};
    }

    private static void jj_la1_init_1() {
        jj_la1_1 = new int[]{128024, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 128024, 0, 32768, 0, 128024, 17424, 4104, 95256, 0, 0, 0, 0, 25616};
    }

    public ExpressionTranslator(Provider stream) {
        int i;
        this.jj_input_stream = new SimpleCharStream(stream, 1, 1);
        this.token_source = new ExpressionTranslatorTokenManager(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 27; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public ExpressionTranslator(String dsl) throws ParseException, TokenMgrException {
        this(new StringProvider(dsl));
    }

    public void ReInit(String s) {
        this.ReInit(new StringProvider(s));
    }

    public void ReInit(Provider stream) {
        int i;
        if (this.jj_input_stream == null) {
            this.jj_input_stream = new SimpleCharStream(stream, 1, 1);
        } else {
            this.jj_input_stream.ReInit(stream, 1, 1);
        }
        if (this.token_source == null) {
            this.token_source = new ExpressionTranslatorTokenManager(this.jj_input_stream);
        }
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 27; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public ExpressionTranslator(ExpressionTranslatorTokenManager tm) {
        int i;
        this.token_source = tm;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 27; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public void ReInit(ExpressionTranslatorTokenManager tm) {
        int i;
        this.token_source = tm;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 27; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    private Token jj_consume_token(int kind) throws ParseException {
        Token oldToken = this.token;
        this.token = oldToken.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        if (this.token.kind == kind) {
            ++this.jj_gen;
            if (++this.jj_gc > 100) {
                this.jj_gc = 0;
                for (int i = 0; i < this.jj_2_rtns.length; ++i) {
                    JJCalls c = this.jj_2_rtns[i];
                    while (c != null) {
                        if (c.gen < this.jj_gen) {
                            c.first = null;
                        }
                        c = c.next;
                    }
                }
            }
            return this.token;
        }
        this.token = oldToken;
        this.jj_kind = kind;
        throw this.generateParseException();
    }

    private boolean jj_scan_token(int kind) {
        if (this.jj_scanpos == this.jj_lastpos) {
            --this.jj_la;
            if (this.jj_scanpos.next == null) {
                this.jj_scanpos = this.jj_scanpos.next = this.token_source.getNextToken();
                this.jj_lastpos = this.jj_scanpos.next;
            } else {
                this.jj_lastpos = this.jj_scanpos = this.jj_scanpos.next;
            }
        } else {
            this.jj_scanpos = this.jj_scanpos.next;
        }
        if (this.jj_rescan) {
            int i = 0;
            Token tok = this.token;
            while (tok != null && tok != this.jj_scanpos) {
                ++i;
                tok = tok.next;
            }
            if (tok != null) {
                this.jj_add_error_token(kind, i);
            }
        }
        if (this.jj_scanpos.kind != kind) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            throw this.jj_ls;
        }
        return false;
    }

    public final Token getNextToken() {
        this.token = this.token.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        ++this.jj_gen;
        return this.token;
    }

    public final Token getToken(int index) {
        Token t = this.token;
        for (int i = 0; i < index; ++i) {
            t = t.next != null ? t.next : (t.next = this.token_source.getNextToken());
        }
        return t;
    }

    private int jj_ntk_f() {
        this.jj_nt = this.token.next;
        if (this.jj_nt == null) {
            this.token.next = this.token_source.getNextToken();
            this.jj_ntk = this.token.next.kind;
            return this.jj_ntk;
        }
        this.jj_ntk = this.jj_nt.kind;
        return this.jj_ntk;
    }

    private void jj_add_error_token(int kind, int pos) {
        if (pos >= 100) {
            return;
        }
        if (pos == this.jj_endpos + 1) {
            this.jj_lasttokens[this.jj_endpos++] = kind;
        } else if (this.jj_endpos != 0) {
            this.jj_expentry = new int[this.jj_endpos];
            for (int i = 0; i < this.jj_endpos; ++i) {
                this.jj_expentry[i] = this.jj_lasttokens[i];
            }
            for (int[] oldentry : this.jj_expentries) {
                if (oldentry.length != this.jj_expentry.length) continue;
                boolean isMatched = true;
                for (int i = 0; i < this.jj_expentry.length; ++i) {
                    if (oldentry[i] == this.jj_expentry[i]) continue;
                    isMatched = false;
                    break;
                }
                if (!isMatched) continue;
                this.jj_expentries.add(this.jj_expentry);
                break;
            }
            if (pos != 0) {
                this.jj_endpos = pos;
                this.jj_lasttokens[this.jj_endpos - 1] = kind;
            }
        }
    }

    public ParseException generateParseException() {
        int i;
        this.jj_expentries.clear();
        boolean[] la1tokens = new boolean[53];
        if (this.jj_kind >= 0) {
            la1tokens[this.jj_kind] = true;
            this.jj_kind = -1;
        }
        for (i = 0; i < 27; ++i) {
            if (this.jj_la1[i] != this.jj_gen) continue;
            for (int j = 0; j < 32; ++j) {
                if ((jj_la1_0[i] & 1 << j) != 0) {
                    la1tokens[j] = true;
                }
                if ((jj_la1_1[i] & 1 << j) == 0) continue;
                la1tokens[32 + j] = true;
            }
        }
        for (i = 0; i < 53; ++i) {
            if (!la1tokens[i]) continue;
            this.jj_expentry = new int[1];
            this.jj_expentry[0] = i;
            this.jj_expentries.add(this.jj_expentry);
        }
        this.jj_endpos = 0;
        this.jj_rescan_token();
        this.jj_add_error_token(0, 0);
        int[][] exptokseq = new int[this.jj_expentries.size()][];
        for (int i2 = 0; i2 < this.jj_expentries.size(); ++i2) {
            exptokseq[i2] = this.jj_expentries.get(i2);
        }
        return new ParseException(this.token, exptokseq, tokenImage, this.token_source == null ? null : ExpressionTranslatorTokenManager.lexStateNames[this.token_source.curLexState]);
    }

    public final void enable_tracing() {
    }

    public final void disable_tracing() {
    }

    private void jj_rescan_token() {
        this.jj_rescan = true;
        for (int i = 0; i < 7; ++i) {
            try {
                JJCalls p = this.jj_2_rtns[i];
                do {
                    if (p.gen <= this.jj_gen) continue;
                    this.jj_la = p.arg;
                    this.jj_lastpos = this.jj_scanpos = p.first;
                    switch (i) {
                        case 0: {
                            this.jj_3_1();
                            break;
                        }
                        case 1: {
                            this.jj_3_2();
                            break;
                        }
                        case 2: {
                            this.jj_3_3();
                            break;
                        }
                        case 3: {
                            this.jj_3_4();
                            break;
                        }
                        case 4: {
                            this.jj_3_5();
                            break;
                        }
                        case 5: {
                            this.jj_3_6();
                            break;
                        }
                        case 6: {
                            this.jj_3_7();
                        }
                    }
                } while ((p = p.next) != null);
                continue;
            }
            catch (LookaheadSuccess lookaheadSuccess) {
                // empty catch block
            }
        }
        this.jj_rescan = false;
    }

    private void jj_save(int index, int xla) {
        JJCalls p = this.jj_2_rtns[index];
        while (p.gen > this.jj_gen) {
            if (p.next == null) {
                p = p.next = new JJCalls();
                break;
            }
            p = p.next;
        }
        p.gen = this.jj_gen + xla - this.jj_la;
        p.first = this.token;
        p.arg = xla;
    }

    static {
        ExpressionTranslator.jj_la1_init_0();
        ExpressionTranslator.jj_la1_init_1();
    }

    static final class JJCalls {
        int gen;
        Token first;
        int arg;
        JJCalls next;

        JJCalls() {
        }
    }

    private static final class LookaheadSuccess
    extends RuntimeException {
        private LookaheadSuccess() {
        }
    }
}

