% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/r2dii.match-package.R
\docType{package}
\name{r2dii.match-package}
\alias{r2dii.match}
\alias{r2dii.match-package}
\title{r2dii.match: Tools to Match Corporate Lending Portfolios with Climate Data}
\description{
\if{html}{\figure{logo.png}{options: style='float: right' alt='logo' width='120'}}

These tools implement in R a fundamental part of the software 'PACTA' (Paris Agreement Capital Transition Assessment), which is a free tool that calculates the alignment between financial portfolios and climate scenarios (\url{https://www.transitionmonitor.com/}). Financial institutions use 'PACTA' to study how their capital allocation decisions align with climate change mitigation goals. This package matches data from corporate lending portfolios to asset level data from market-intelligence databases (e.g. power plant capacities, emission factors, etc.). This is the first step to assess if a financial portfolio aligns with climate goals.
}
\seealso{
Useful links:
\itemize{
  \item \url{https://rmi-pacta.github.io/r2dii.match/}
  \item \url{https://github.com/RMI-PACTA/r2dii.match}
  \item Report bugs at \url{https://github.com/RMI-PACTA/r2dii.match/issues}
}

}
\author{
\strong{Maintainer}: Alex Axthelm \email{aaxthelm@rmi.org} (\href{https://orcid.org/0000-0001-8579-8565}{ORCID})

Authors:
\itemize{
  \item Jackson Hoffart \email{jackson.hoffart@gmail.com} (\href{https://orcid.org/0000-0002-8600-5042}{ORCID}) [contractor]
  \item Mauro Lepore \email{maurolepore@gmail.com} (\href{https://orcid.org/0000-0002-1986-7988}{ORCID}) [contractor]
  \item Klaus Hagedorn \email{klaus@2degrees-investing.org}
  \item Florence Palandri \email{florence@2degrees-investing.org}
  \item Evgeny Petrovsky
}

Other contributors:
\itemize{
  \item Jacob Kastl \email{jacob.kastl@gmail.com} (\href{https://orcid.org/0009-0000-8281-8129}{ORCID}) [contractor]
  \item RMI \email{PACTA4banks@rmi.org} [copyright holder, funder]
}

}
\keyword{internal}
