% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summarize_weighted_production.R
\name{summarize_weighted_production}
\alias{summarize_weighted_production}
\title{Summarize production based on the weight of each loan per sector per year}
\usage{
summarize_weighted_production(data, ..., use_credit_limit = FALSE)
}
\arguments{
\item{data}{A data frame like the output of \code{\link[=join_ald_scenario]{join_ald_scenario()}}.}

\item{...}{Variables to group by.}

\item{use_credit_limit}{Logical vector of length 1. \code{FALSE} defaults to using
the column \code{loan_size_outstanding}. Set to \code{TRUE} to use the column
\code{loan_size_credit_limit} instead.}
}
\value{
A tibble with the same groups as the input (if any) and columns:
\code{sector}, \code{technology}, \code{year}, and \code{weighted_production}.
}
\description{
Summarize production based on the weight of each loan per sector per year.
}
\examples{
library(r2dii.analysis)
library(r2dii.data)
library(r2dii.match)

master <- r2dii.data::loanbook_demo \%>\%
  r2dii.match::match_name(r2dii.data::ald_demo) \%>\%
  r2dii.match::prioritize() \%>\%
  join_ald_scenario(r2dii.data::ald_demo,
    r2dii.data::scenario_demo_2020,
    region_isos = region_isos_demo
  )

summarize_weighted_production(master)

summarize_weighted_production(master, use_credit_limit = TRUE)
}
\seealso{
\code{\link[=join_ald_scenario]{join_ald_scenario()}}.

Other utility functions: 
\code{\link{join_ald_scenario}()}
}
\concept{utility functions}
