% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mean_sd.R
\name{mean_sd}
\alias{mean_sd}
\alias{gmean_sd}
\title{Mean and Standard deviation}
\usage{
mean_sd(
  x,
  digits = getOption("qwraps2_frmt_digits", 2),
  na_rm = FALSE,
  show_n = "ifNA",
  denote_sd = "pm",
  markup = getOption("qwraps2_markup", "latex")
)

gmean_sd(
  x,
  digits = getOption("qwraps2_frmt_digits", 2),
  na_rm = FALSE,
  show_n = "ifNA",
  denote_sd = "pm",
  markup = getOption("qwraps2_markup", "latex")
)
}
\arguments{
\item{x}{a numeric vector}

\item{digits}{digits to the right of the decimal point to return in the
percentage estimate.}

\item{na_rm}{if true, omit NA values}

\item{show_n}{defaults to "ifNA".  Other options are "always" or "never".}

\item{denote_sd}{a character string set to either "pm" or "paren" for reporting 'mean
\eqn{\pm} sd' or 'mean (sd)'}

\item{markup}{latex or markdown}
}
\value{
a character vector of the formatted values
}
\description{
A function for calculating and formatting means and 
standard deviations.
}
\details{
Given a numeric vector, \code{mean_sd} will return a character string with
the mean and standard deviation.  Formating of the output will be extended in
future versions.  

\code{gmean_sd} returns the geometric mean and geometric standard deviation.
}
\examples{
set.seed(42)
x <- rnorm(1000, 3, 4)
mean(x)
sd(x)
mean_sd(x)
mean_sd(x, show_n = "always")
mean_sd(x, show_n = "always", denote_sd = "paren")

x[187] <- NA
mean_sd(x, na_rm = TRUE)

}
