% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/2d.R
\name{gen_edges}
\alias{gen_edges}
\title{Generate edge information}
\usage{
gen_edges(tri_object)
}
\arguments{
\item{tri_object}{The triangular object from which to generate edge information.}
}
\value{
A data frame containing the edge information, including the from-to
relationships and the corresponding x and y coordinates.
}
\description{
This function generates edge information from a given triangular object,
including the coordinates of the vertices and the from-to relationships
between the vertices.
}
\examples{
num_bins_list <- calc_bins(data = s_curve_noise_umap_scaled, x = "UMAP1",
y = "UMAP2", hex_size = NA, buffer_x = NA, buffer_y = NA)
num_bins_x <- num_bins_list$num_x
num_bins_y <- num_bins_list$num_y
hb_obj <- hex_binning(data = s_curve_noise_umap_scaled,
x = "UMAP1", y = "UMAP2", num_bins_x = num_bins_x,
num_bins_y = num_bins_y, x_start = NA, y_start = NA, buffer_x = NA,
buffer_y = NA, hex_size = NA, col_start = "UMAP")
all_centroids_df <- as.data.frame(do.call(cbind, hb_obj$centroids))
counts_df <- as.data.frame(do.call(cbind, hb_obj$std_cts))
df_bin_centroids <- extract_hexbin_centroids(centroids_df = all_centroids_df, counts_df = counts_df)
tr1_object <- tri_bin_centroids(hex_df = df_bin_centroids, x = "c_x", y = "c_y")
gen_edges(tri_object = tr1_object)

}
