% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/highd.R
\name{avg_highd_data}
\alias{avg_highd_data}
\title{Create a dataframe with averaged high-dimensional data}
\usage{
avg_highd_data(data, col_start = "x")
}
\arguments{
\item{data}{A data frame containing the high-dimensional data and 2D embeddings
with hexagonal bin IDs.}

\item{col_start}{The text that begin the column name of the high-dimensional data}
}
\value{
A data frame with the average values of the high-dimensional data within each hexagonal bin.
}
\description{
This function calculates the average values of high-dimensional data within each hexagonal bin.
}
\examples{
num_bins_list <- calc_bins(data = s_curve_noise_umap_scaled, x = "UMAP1",
y = "UMAP2", hex_size = NA, buffer_x = NA, buffer_y = NA)
num_bins_x <- num_bins_list$num_x
num_bins_y <- num_bins_list$num_y
hb_obj <- hex_binning(data = s_curve_noise_umap_scaled,
x = "UMAP1", y = "UMAP2", num_bins_x = num_bins_x,
num_bins_y = num_bins_y, x_start = NA, y_start = NA, buffer_x = NA,
buffer_y = NA, hex_size = NA, col_start = "UMAP")
umap_data_with_hb_id <- as.data.frame(do.call(cbind, hb_obj$data_hb_id))
df_all <- dplyr::bind_cols(s_curve_noise_training |> dplyr::select(-ID), umap_data_with_hb_id)
avg_highd_data(data = df_all, col_start = "x")

}
