% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_performance_metrics.R
\name{get_performance_metrics}
\alias{get_performance_metrics}
\title{Get PGS Catalog Performance Metrics}
\usage{
get_performance_metrics(
  ppm_id = NULL,
  pgs_id = NULL,
  set_operation = "union",
  interactive = TRUE,
  verbose = FALSE,
  warnings = TRUE,
  progress_bar = TRUE
)
}
\arguments{
\item{ppm_id}{A character vector of PGS Catalog performance metrics accession
identifiers.}

\item{pgs_id}{A \code{character} vector of PGS Catalog score accession
identifiers.}

\item{set_operation}{Either \code{'union'} or \code{'intersection'}. This
tells how performance metrics retrieved by different criteria  should be combined:
\code{'union'} binds together all results removing duplicates and
\code{'intersection'} only keeps same performance metrics found with different
criteria.}

\item{interactive}{A logical. If all performance metrics are requested, whether to ask
interactively if we really want to proceed.}

\item{verbose}{A \code{logical} indicating whether the function should be
verbose about the different queries or not.}

\item{warnings}{A \code{logical} indicating whether to print warnings, if any.}

\item{progress_bar}{Whether to show a progress bar as the queries are
performed.}
}
\value{
A \linkS4class{performance_metrics} object.
}
\description{
Retrieves performance metrics via the PGS Catalog REST API. The REST
API is queried multiple times with the criteria passed as arguments (see
below). By default all performance metrics that match the criteria supplied in the
arguments are retrieved: this corresponds to the default option
\code{set_operation} set to \code{'union'}. If you rather have only the
associations that match simultaneously all criteria provided, then set
\code{set_operation} to \code{'intersection'}.
}
\details{
Please note that all search criteria are vectorised, thus allowing for batch
mode search.
}
\examples{
\dontrun{
# Get performance metrics catalogued with identifier 'PPM000001'
get_performance_metrics(ppm_id = 'PPM000001')

# Get performance metrics associated with polygenic score id 'PGS000001'
get_performance_metrics(pgs_id = 'PGS000001')

# To retrieve all catalogued performed metrics in PGS Catalog you simply
# leave the parameters `ppm_id` and `pgs_id` as `NULL`.
get_performance_metrics()
}

}
