% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/id_mapping.R
\name{pgs_to_study}
\alias{pgs_to_study}
\title{Map PGS identifiers to GWAS study identifiers}
\usage{
pgs_to_study(
  pgs_id = NULL,
  verbose = FALSE,
  warnings = TRUE,
  progress_bar = TRUE
)
}
\arguments{
\item{pgs_id}{A character vector of PGS Catalog score accession identifiers.,
e.g., "PGS000001". If \code{NULL} then returns results for all PGS
identifiers in the Catalog.}

\item{verbose}{A \code{logical} indicating whether the function should be
verbose about the different queries or not.}

\item{warnings}{A \code{logical} indicating whether to print warnings, if
any.}

\item{progress_bar}{Whether to show a progress bar as the queries are
performed.}
}
\value{
A data frame of two columns: \code{pgs_id} and \code{study_id}.
}
\description{
Map PGS identifiers to GWAS study identifiers. Retrieves GWAS study
identifiers associated with samples used in the discovery stage of queried
PGS identifiers.
}
\examples{
\dontrun{
pgs_to_study('PGS000001')
# Unmappable pgs ids will be missing, e.g., PGS000023
pgs_to_study(c('PGS000013', 'PGS000023'))
}
}
