% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/libraryAll.R
\name{libraryAll}
\alias{libraryAll}
\title{Load specific R libraries and clear environment}
\usage{
libraryAll(
  ...,
  lib.loc = NULL,
  quietly = FALSE,
  clear = TRUE,
  clearPkgs = FALSE
)
}
\arguments{
\item{...}{multiple library names}

\item{lib.loc}{OPTIONAL. library store location}

\item{quietly}{OPTIONAL. attach library quietly}

\item{clear}{OPTIONAL. clear environment after attach}

\item{clearPkgs}{Clear previous loaded packages, TRUE or FALSE}
}
\value{
loaded libraries and clear environment
}
\description{
Load specific packages, print a list of the loaded packages along with versions.
Only include libraries, don't install if library doesn't exist
}
\examples{
\donttest{
# load packages and print their versions to the console
libraryAll(base) #one package

libraryAll(
  base,
  tools,
  stats
) #multiple packages

libraryAll("grDevices") #with quotes

libraryAll(
  stats,
  utils,
  quietly = TRUE
) #load quietly

libraryAll(
  base,
clear = FALSE) #do not clear console after load

# clear previously loaded packages, then load r2resize and r2social
libraryAll(
  stats,
  utils,
  clearPkgs = TRUE
)
}
}
