% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/display.data.frame.R
\name{display.data.frame}
\alias{display.data.frame}
\title{Display summary information of varibles in a data.frame}
\usage{
\method{display}{data.frame}(x = NULL, col = NULL, normtest = NULL,
  continuous_limit = 10, useNA = "ifany", ...)
}
\arguments{
\item{x}{A data.frame}

\item{col}{Column indices of variables in the dataset to display, the default columns are all the variables}

\item{normtest}{A character indicating test of normality, the default method is \code{\link{shapiro.test}} when sample size no more than 5000, otherwise \code{\link[nortest]{lillie.test}}{Kolmogorov-Smirnov} is used, see package \strong{nortest} for more methods.Use "shapiro.test", "lillie.test", "ad.test", etc to specify methods.}

\item{continuous_limit}{A numeric defining the minimal of different value to display the variable as count and frequency}

\item{useNA}{Whether to include NA values in the table, see \code{\link{table}} for more details}

\item{\dots}{additional arguments}
}
\description{
Dispaly count, frequency or mean, standard deviation and test of normality, etc.
}
\examples{
data(diabetes)
head(diabetes)
display(diabetes,1:2)
display(diabetes,1:11)
}
\seealso{
\code{\link{display.reg}},  \code{\link{display}}
}

