% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{as.server.list}
\alias{as.server.list}
\title{Creates a \code{"server.list"} object from a list of times and starting availability.}
\usage{
as.server.list(times, init)
}
\arguments{
\item{times}{list of numeric vectors giving change times for each server.}

\item{init}{vector of 1s and 0s with equal length to \code{times}.
It represents whether the server starts in an availabile \code{(1)} or unavailable \code{(0)} state.}
}
\value{
an object of class \code{"server.list"}, which is a list of step functions of range \{0, 1\}.
}
\description{
Creates a \code{"server.list"} object from a list of times and starting availability.
}
\examples{
# Create a server.list object with the first server available anytime before time 10,
# and the second server available between time 15 and time 30.
as.server.list(list(10, c(15,30)), c(1,0))
}
\seealso{
\code{\link{as.server.stepfun}}, \code{\link{queue_step}}
}
