% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/core_queuefunctions.R
\name{queue}
\alias{queue}
\title{Compute the departure times of a set of customers in a queue from their arrival and service times.}
\usage{
queue(arrivals, service, servers = 1, serveroutput = FALSE)
}
\arguments{
\item{arrivals}{numeric vector of non-negative arrival times}

\item{service}{numeric vector of non-negative service times}

\item{servers}{a non-zero natural number, an object of class \code{server.stepfun}
or an object of class \code{server.list}.}

\item{serveroutput}{boolean whether the server used by each customer should be returned.}
}
\description{
\code{queue} is a faster internal version of \code{queue_step}. It is not compatible with the \code{summary.queue_df} method.
}
\examples{
queue(rep(1, 7), service = rep(0.2, 7),
servers = as.server.stepfun(3.1, c(2, 1)))
}
\seealso{
\code{\link{queue_step}}
}

