% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/run.R
\name{quarto_run}
\alias{quarto_run}
\title{Run Interactive Document}
\usage{
quarto_run(
  input,
  render = TRUE,
  port = getOption("shiny.port"),
  host = getOption("shiny.host", "127.0.0.1"),
  browse = TRUE
)
}
\arguments{
\item{input}{The input file to run. Should be a file with
a \code{server: shiny} entry in its YAML front-matter.}

\item{render}{Render the document before running it.}

\item{port}{Port to listen on (defaults to 4848)}

\item{host}{Hostname to bind to (defaults to 127.0.0.1)}

\item{browse}{Open a browser to preview the content. Defaults to using the
RStudio Viewer when running within RStudio.Pass a function (e.g.
\code{utils::browseURL} to override this behavior).}
}
\description{
Run a Shiny interactive document. By default, the document will
be rendered first and then run. If you have previously rendered
the document, pass \code{render - FALSE} to skip rendering.
}
