% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rashomon-quartet.R
\docType{data}
\name{rashomon_quartet}
\alias{rashomon_quartet}
\alias{rashomon_quartet_train}
\alias{rashomon_quartet_test}
\title{Rashomon Quartet Data}
\format{
\code{rashomon_quartet}: A dataframe with 2000 rows and 5 variables:
\itemize{
\item \code{split}: train, test
\item \code{x1}
\item \code{x2}
\item \code{x3}
\item \code{y}
}

\code{rashomon_quartet_train}: A dataframe with 1000 rows and 4 variables:
\itemize{
\item \code{x1}
\item \code{x2}
\item \code{x3}
\item \code{y}
}

\code{rashomon_quartet_test}: A dataframe with 1000 rows and 4 variables:
\itemize{
\item \code{x1}
\item \code{x2}
\item \code{x3}
\item \code{y}
}
}
\usage{
rashomon_quartet

rashomon_quartet_train

rashomon_quartet_test
}
\description{
This dataset contains 2,000 observations, 1,000 training observations and
1,000 testing observations. These were generated such that 4 modeling
techniques (regression tree, linear model, neural network, random forest)
will yield the same \eqn{R^2} and RMSE but will fit the models very differently.
}
\details{
There are three explanatory variables \code{x1}, \code{x2}, \code{x3} and one outcome \code{y}
generated as:

\eqn{y = sin((3x_1 + x_2)/5)+\varepsilon}

where \eqn{\varepsilon\sim N(0,1/3)} and \eqn{[x_1,x_2,x_3]\sim N(0, \Sigma_{3x3})}
and \eqn{\Sigma_{3x3}} has 1 on the diagonal and 0.9 elsewhere.

If fit using the following hyperparameters, each model will yield an \eqn{R^2} of 0.73 and an RMSE of 0.354
\itemize{
\item Regression tree: max depth: 3, min split: 250
\item Linear model: all main effects
\item Random Forest: mtry: 1, number of trees: 100
\item Neural network: hidden neurons in each layer: 8, 4, threshold for partial derivatives of the error function as stopping criteria: 0.05
}

\code{\link{rashomon_quartet_train}} contains just the training data and \code{\link{rashomon_quartet_test}} contains only the test data.
}
\references{
P. Biecek, H. Baniecki, M. Krzyziński, D. Cook. Performance is not enough: the story of Rashomon’s quartet. Preprint arXiv:2302.13356v2, 2023.
}
\keyword{datasets}
