% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Class-QuantileSD.R
\docType{methods}
\name{getCoherency-QuantileSD}
\alias{getCoherency,QuantileSD-method}
\alias{getCoherency-QuantileSD}
\title{Compute quantile coherency from a quantile spectral density kernel}
\usage{
\S4method{getCoherency}{QuantileSD}(object, frequencies = 2 * pi *
  (0:(object@N - 1))/object@N, levels.1 = getLevels(object, 1),
  levels.2 = getLevels(object, 2), d1 = 1:(dim(object@values)[2]),
  d2 = 1:(dim(object@values)[4]))
}
\arguments{
\item{object}{\code{QuantileSD} of which to get the values}

\item{frequencies}{a vector of frequencies for which to get the values}

\item{levels.1}{the first vector of levels for which to get the values}

\item{levels.2}{the second vector of levels for which to get the values}

\item{d1}{optional parameter that determine for which j1 to return the
data; may be a vector of elements 1, ..., D}

\item{d2}{same as d1, but for j2}
}
\value{
Returns data from the coherency as defined in the details.
}
\description{
Returns quantile coherency defined as
\deqn{\frac{f^{j_1, j_2}(\omega; \tau_1, \tau_2)}{(f^{j_1, j_1}(\omega; \tau_1, \tau_1) f^{j_2, j_2}(\omega; \tau_2, \tau_2))^{1/2}}}
where \eqn{f^{j_1, j_2}(\omega; \tau_1, \tau_2)} is the quantile spectral density.
}
\details{
For the mechanism of selecting frequencies, dimensions and/or levels see,
for example, \code{\link{getValues-QuantileSD}}.
}
\seealso{
For examples on how to use this function go to \code{\link{QuantileSD}}.
}
\keyword{Access-functions}

