% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fcm-classes.R, R/fcm-subsetting.R
\docType{class}
\name{fcm-class}
\alias{fcm-class}
\alias{t,fcm-method}
\alias{Arith,fcm,numeric-method}
\alias{Arith,numeric,fcm-method}
\alias{[,fcm,index,index,missing-method}
\alias{[,fcm,index,index,logical-method}
\alias{[,fcm,missing,missing,missing-method}
\alias{[,fcm,missing,missing,logical-method}
\alias{[,fcm,index,missing,missing-method}
\alias{[,fcm,index,missing,logical-method}
\alias{[,fcm,missing,index,missing-method}
\alias{[,fcm,missing,index,logical-method}
\title{Virtual class "fcm" for a feature co-occurrence matrix}
\usage{
\S4method{t}{fcm}(x)

\S4method{Arith}{fcm,numeric}(e1, e2)

\S4method{Arith}{numeric,fcm}(e1, e2)

\S4method{[}{fcm,index,index,missing}(x, i, j, ..., drop = TRUE)

\S4method{[}{fcm,index,index,logical}(x, i, j, ..., drop = TRUE)

\S4method{[}{fcm,missing,missing,missing}(x, i, j, ..., drop = TRUE)

\S4method{[}{fcm,missing,missing,logical}(x, i, j, ..., drop = TRUE)

\S4method{[}{fcm,index,missing,missing}(x, i, j, ..., drop = TRUE)

\S4method{[}{fcm,index,missing,logical}(x, i, j, ..., drop = TRUE)

\S4method{[}{fcm,missing,index,missing}(x, i, j, ..., drop = TRUE)

\S4method{[}{fcm,missing,index,logical}(x, i, j, ..., drop = TRUE)
}
\arguments{
\item{x}{the fcm object}

\item{e1}{first quantity in "+" operation for fcm}

\item{e2}{second quantity in "+" operation for fcm}

\item{i}{index for features}

\item{j}{index for features}

\item{...}{additional arguments not used here}

\item{drop}{always set to \code{FALSE}}
}
\description{
The fcm class of object is a special type of \link{fcm} object with
additional slots, described below.
}
\section{Slots}{

\describe{
\item{\code{context}}{the context definition}

\item{\code{window}}{the size of the window, if \code{context = "window"}}

\item{\code{count}}{how co-occurrences are counted}

\item{\code{weights}}{context weighting for distance from target feature, equal in length to \code{window}}

\item{\code{margin}}{frequencies of features in the original \link{dfm} or \link{tokens}}

\item{\code{tri}}{whether the lower triangle of the symmetric \eqn{V \times V} matrix is recorded}

\item{\code{ordered}}{whether a term appears before or after the target feature
are counted separately}
}}

\examples{
# fcm subsetting
fcmat <- fcm(tokens(c("this contains lots of stopwords",
                  "no if, and, or but about it: lots"),
                remove_punct = TRUE))
fcmat[1:3, ]
fcmat[4:5, 1:5]


}
\seealso{
\link{fcm}
}
\keyword{fcm}
\keyword{internal}
