% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tokens_replace.R
\name{tokens_replace}
\alias{tokens_replace}
\title{replace types in tokens object}
\usage{
tokens_replace(x, pattern, replacement = NULL, case_insensitive = TRUE,
  verbose = quanteda_options("verbose"))
}
\arguments{
\item{x}{\link{tokens} object whose token elements will be replaced}

\item{pattern}{a character vector or \link{dictionary}.  See \link{pattern}
for more details.}

\item{replacement}{if \code{pattern} is a character vector, then \code{replacement}
must be character vector of equal length, for a 1:1 match.  If \code{pattern} is
a \link{dictionary}, then \code{replacement} should not be used.}

\item{case_insensitive}{ignore case when matching, if \code{TRUE}}

\item{verbose}{print status messages if \code{TRUE}}
}
\description{
Substitute token types based on vectorized one-to-one matching. Since this
function is created for lemmatization or user-defined stemming, it does not
support multi-word features, or glob and regex patterns. Please use
\code{\link{tokens_lookup}} with \code{exclusive = FALSE} for substitutions
of more complex patterns.
}
\examples{
toks <- tokens(data_corpus_irishbudget2010)

# lemmatization
infle <- c("foci", "focus", "focused", "focuses", "focusing", "focussed", "focusses")
lemma <- rep("focus", length(infle))
toks2 <- tokens_replace(toks, infle, lemma)
kwic(toks2, "focus*")

# stemming
type <- types(toks)
stem <- char_wordstem(type, "porter")
toks3 <- tokens_replace(toks, type, stem, case_insensitive = FALSE)
identical(toks3, tokens_wordstem(toks, "porter"))
}
