% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/docvars.R
\name{docvars}
\alias{docvars}
\alias{docvars<-}
\title{get or set for document-level variables}
\usage{
docvars(x, field = NULL)

docvars(x, field = NULL) <- value
}
\arguments{
\item{x}{\link{corpus}, \link{tokens}, or \link{dfm} object whose 
document-level variables will be read or set}

\item{field}{string containing the document-level variable name}

\item{value}{the new values of the document-level variable}
}
\value{
\code{docvars} returns a data.frame of the document-level variables, 
  dropping the second dimension to form a vector if a single docvar is 
  returned.

\code{docvars<-} assigns \code{value} to the named \code{field}
}
\description{
Get or set variables associated with a document in a \link{corpus},
\link{tokens} or \link{dfm} object.
}
\note{
Reassigning document variables for a \link{tokens} or \link{dfm} object
is allowed, but discouraged.  A better, more reproducible workflow is to
create your docvars as desired in the \link{corpus}, and let these continue
to be attached "downstream" after tokenization and forming a document-feature
matrix.  Recognizing that in some cases, you may need to modify or add
document variables to downstream objects, the assignment operator is defined
for \link{tokens} or \link{dfm} objects as well.  Use with caution.
}
\section{Index access to docvars in a corpus}{

Another way to access and set docvars is through indexing of the corpus 
\code{j} element, such as \code{data_corpus_irishbudget2010[, c("foren", 
"name"]}; or, for a single docvar, 
\code{data_corpus_irishbudget2010[["name"]]}.  The latter also permits 
assignment, including the easy creation of new document variables, e.g. 
\code{data_corpus_irishbudget2010[["newvar"]] <- 
1:ndoc(data_corpus_irishbudget2010)}. See \code{\link{[.corpus}} for details.
}

\examples{
# retrieving docvars from a corpus
head(docvars(data_corpus_inaugural))
tail(docvars(data_corpus_inaugural, "President"), 10)

# assigning document variables to a corpus
corp <- data_corpus_inaugural
docvars(corp, "President") <- paste("prez", 1:ndoc(corp), sep = "")
head(docvars(corp))

# alternative using indexing
head(corp[, "Year"])
corp[["President2"]] <- paste("prezTwo", 1:ndoc(corp), sep = "")
head(docvars(corp))

}
\keyword{corpus}
