% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/convert.R
\name{convert-wrappers}
\alias{convert-wrappers}
\alias{as.wfm}
\alias{as.DocumentTermMatrix}
\alias{dfm2ldaformat}
\alias{quantedaformat2dtm}
\title{convenience wrappers for dfm convert}
\usage{
as.wfm(x)

as.DocumentTermMatrix(x, ...)

dfm2ldaformat(x)

quantedaformat2dtm(x)
}
\arguments{
\item{x}{the dfm to be converted}

\item{...}{additional arguments used only by \code{as.DocumentTermMatrix}}
}
\value{
A converted object determined by the value of \code{to} (see above). 
  See conversion target package documentation for more detailed descriptions 
  of the return formats.
}
\description{
To make the usage as consistent as possible with other packages, quanteda
also provides shortcut wrappers to \code{\link{convert}}, designed to be
similar in syntax to analogous commands in the packages to whose format they
are converting.
}
\details{
\code{as.wfm} converts a quanteda \link{dfm} into the
\code{wfm} format used by the \code{austin} package.

\code{as.DocumentTermMatrix} will convert a quanteda \link{dfm} into
  the \pkg{tm} package's \link[tm]{DocumentTermMatrix} format. Note: The
  \pkg{tm} package version of \code{as.TermDocumentMatrix} allows a
  \code{weighting} argument, which supplies a weighting function for 
  \link[tm]{TermDocumentMatrix}.  Here the default is for term frequency
  weighting. If you want a different weighting, apply the weights after
  converting using one of the \pkg{tm} functions. For other available
  weighting functions from the \pkg{tm} package, see 
  \code{\link[tm]{TermDocumentMatrix}}.

\code{dfm2ldaformat} provides converts a \link{dfm} into the list representation
of terms in documents used by the \pkg{lda} package (a list with components 
"documents" and "vocab" as needed by 
  \code{\link[lda]{lda.collapsed.gibbs.sampler}}).

\code{quantedaformat2dtm} provides converts a \link{dfm} into the
sparse simple triplet matrix representation of terms in documents used by the
\pkg{topicmodels} package.
}
\note{
Additional coercion methods to base R objects are also available: 
  \describe{ \item{\code{\link{as.data.frame}(x)}}{converts a \link{dfm} into
  a \link{data.frame}}
  
  \item{\code{\link{as.matrix}(x)}}{converts a \link{dfm} into a
  \link{matrix}} }
}
\examples{
mycorpus <- corpus_subset(data_corpus_inaugural, Year > 1970)
quantdfm <- dfm(mycorpus, verbose = FALSE)

# shortcut conversion to austin package's wfm format
identical(as.wfm(quantdfm), convert(quantdfm, to = "austin"))

\dontrun{
# shortcut conversion to tm package's DocumentTermMatrix format
identical(as.DocumentTermMatrix(quantdfm), convert(quantdfm, to = "tm"))
}

\dontrun{
# shortcut conversion to lda package list format
identical(dfm2ldaformat(quantdfm), convert(quantdfm, to = "lda")) 
}

# shortcut conversion to topicmodels package format
\dontrun{
identical(quantedaformat2dtm(quantdfm), 
          convert(quantdfm, to = "topicmodels")) 
}

}
\keyword{internal}
