% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plots.R
\name{plot.dfm}
\alias{plot.dfm}
\title{plot features as a wordcloud}
\usage{
\method{plot}{dfm}(x, comparison = FALSE, ...)
}
\arguments{
\item{x}{a dfm object}

\item{comparison}{if \code{TRUE}, plot a
\code{\link[wordcloud]{comparison.cloud}} instead of a simple wordcloud,
one grouping per document}

\item{...}{additional parameters passed to to \link[wordcloud]{wordcloud} or 
to \link{text} (and \link{strheight}, \link{strwidth})}
}
\description{
The default plot method for a \code{\link{dfm}} object.  Produces a wordcloud
plot for the features of the dfm, where the feature labels are plotted with 
their sizes proportional to their numerical values in the dfm.  When 
\code{comparison = TRUE}, it plots comparison word clouds by document.
}
\details{
The default is to plot the word cloud of all of the features in the 
  dfm, summed across documents.  To produce word cloud plots for specific 
  document or set of documents, you need to slice out the document(s) from
  the dfm.
  
  Comparison word cloud plots may be plotted by setting 
  \code{comparison = TRUE}, which plots a separate grouping for 
  \emph{each document} in the dfm.
  This means that you will need to slice out just a few documents from the
  dfm, or to create a dfm where the "documents" represent a subset or a
  grouping of documents by some document variable.
}
\examples{
# plot the features (without stopwords) from Obama's two inaugural addresses
mydfm <- dfm(subset(inaugCorpus, President=="Obama"), verbose = FALSE,
             ignoredFeatures = stopwords("english"))
plot(mydfm)

# plot in colors with some additional options passed to wordcloud
plot(mydfm, random.color = TRUE, rot.per = .25, colors = sample(colors()[2:128], 5))

\dontrun{
# comparison plot of Irish government vs opposition
docvars(ie2010Corpus, "govtopp") <- 
    factor(ifelse(ie2010Corpus[, "party"] \%in\% c("FF", "Green"), "Govt", "Opp"))
govtoppDfm <- dfm(ie2010Corpus, groups = "govtopp", verbose = FALSE)
plot(tfidf(govtoppDfm), comparison = TRUE)
# compare to non-tf-idf version
plot(govtoppDfm, comparison = TRUE)
}
}
\seealso{
\code{\link[wordcloud]{wordcloud}},
  \code{\link[wordcloud]{comparison.cloud}}
}

