% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DateManipulation.R
\name{AddBusinessDays}
\alias{AddBusinessDays}
\title{AddBusinessDays}
\usage{
AddBusinessDays(date = Sys.Date(), numDate, loc = "BOG")
}
\arguments{
\item{date}{Initial date, the default is set to the date returned by Sys.Date().}

\item{numDate}{Number of dates to be add (positive or negative).}

\item{loc}{String that determines the location for business days. See details.}
}
\value{
The output is the final date after adding the number of business dates to the initial date.
If the initial date is a non-working date, the result of the function for numDate equal to 0 or 1
is the same.
}
\description{
Function to add a number of business days to a specific date. Currently the function work for
returning values between 1990 and 2100.
}
\details{
loc refers to the location for business days:
 \itemize{
     \item NY for New York Stock Exchange Market.
     \item NYGB for New York Government Bonds Market.
     \item LDN for London.
     \item NYLDN for the intersection of business days in New York Stock Exchange and London.
     \item NYGBLDN for the intersection of business days in New York Government Bond and London.
     \item BOG for Bogota.
     \item BOGNY for the intersection of business days in Bogota and New York Government Bond.
     \item BOGNYGB for the intersection of business days in Bogota and New York Stock Exchange.
}
}
\examples{
# Date input as Date object
AddBusinessDays(date = Sys.Date(),numDate = 15,loc = 'BOG')

# Date input as character object
AddBusinessDays(date = as.character(Sys.Date()),numDate = 15,loc = 'BOG')

}
\author{
Diego Jara and Juan Pablo Bermudez
}
