% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/readSurvey.R
\name{readSurvey}
\alias{readSurvey}
\title{Read comma separated csv file from Qualtrics.}
\usage{
readSurvey(file_name, convertStandardColumns = TRUE, stripHTML = TRUE)
}
\arguments{
\item{file_name}{A csv data file.}

\item{convertStandardColumns}{logical, defaults to TRUE. If TRUE, then the function will convert general data columns (first name, last name, lat, lon, ip address, startdate, enddate etc.) to their proper format.}

\item{stripHTML}{logical, defaults to TRUE. If TRUE, then remove html tags.}
}
\value{
A data frame. Variable labels are stored as attributes. They are not printed on
the console but are visibile in the RStudio viewer.
}
\description{
#' \code{readSurvey}
Reads comma separated csvdata files generated by Qualtrics
software. The second line containing the variable labels is imported.
Repetitive introductions to matrix questions are automatically removed.
Variable labels are stored as attributes.
}
\examples{
\dontrun{
my_data_frame <- readSurvey(my_csv_file)
}
}
\author{
Adrian Brugger, Stefan Borer & Jasper Ginn
}
