% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getSurveys.R
\name{getSurveys}
\alias{getSurveys}
\title{Retrieve a list of all active surveys that you own on qualtrics}
\usage{
getSurveys(headers,
  survey_baseurl = "https://yourdatacenterid.qualtrics.com/API/v3/surveys")
}
\arguments{
\item{headers}{'headers' object - returned by the 'constructHeader' function. See \link[qualtRics]{constructHeader}.}

\item{survey_baseurl}{Base url for your institution (see \url{https://api.qualtrics.com/docs/root-url}. If you do not fill in anything, the function will use the default url. Using your institution-specific url can significantly speed up queries.)}
}
\description{
Retrieve a list of all active surveys that you own on qualtrics
}
\examples{
\dontrun{
head <- constructHeader("<YOUR-API-KEY-HERE>")
surveys <- getSurveys(head,
                      "https://leidenuniv.eu.qualtrics.com/API/v3/responseexports/")
                      # URL is for my own institution.
                      # Substitute with your own institution's url
mysurvey <- getSurvey(surveys$id[6],
                      head,
                      "https://leidenuniv.eu.qualtrics.com/API/v3/responseexports/",
                      verbose=TRUE)
}
}
\author{
Jasper Ginn
}
\seealso{
See \url{https://api.qualtrics.com/docs} for documentation on the Qualtrics API.
}

