% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qm_create.R
\name{qm_create}
\alias{qm_create}
\title{Create cluster object}
\usage{
qm_create(ref, key, value, rid, cid, category, ...)
}
\arguments{
\item{ref}{An \code{sf} object that serves as a master list of features}

\item{key}{Name of geographic id variable in the \code{ref} object to match input values to}

\item{value}{A vector of input values created with \code{qm_define}}

\item{rid}{Respondent identification number; a user defined integer value that uniquely identifies respondents
in the project}

\item{cid}{Cluster identification number; a user defined integer value that uniquely identifies clusters}

\item{category}{Category type; a user defined value that describes what the cluster represents}

\item{...}{An unquoted list of variables from the sf object to include in the output}
}
\value{
A tibble with the cluster values merged with elements of the reference data. This tibble is stored with
a custom class of \code{qm_cluster} to facilitate data validation.
}
\description{
Each vector of input values is converted to a tibble organized in a "tidy" fashion.
}
\details{
A cluster object contains a row for each feature in the reference data set. The \code{key} variable
values are included in a variable named identically to the \code{key}. Additionally, a variable called
\code{COUNT} is created. This will always be equal to \code{1} for each observation. It is intended to be
used for summarization later in the data analysis process. Finally, three pieces of metadata are also included
as arguments to provide data for subsetting later: a respondent identification number (\code{rid}), a
cluster identification number (\code{cid}), and a category for the cluster type (\code{category}). These
arguments are converted into values for the output variables \code{RID}, \code{CID}, and \code{CAT} respectively.
Input data for \code{qm_create} are validated using \code{qm_validate} as part of the cluster object
creation process.
}
\examples{
# load and format reference data
stl <- stLouis
stl <- dplyr::mutate(stl, TRACTCE = as.numeric(TRACTCE))

# create cluster
cluster <- qm_define(118600, 119101, 119300)

# create simple cluster object
cluster_obj1 <- qm_create(ref = stl, key = TRACTCE, value = cluster,
    rid = 1, cid = 1, category = "positive")

# create cluster object with additional variables added from reference data
cluster_obj2 <- qm_create(ref = stl, key = TRACTCE, value = cluster,
    rid = 1, cid = 1, category = "positive", NAME, NAMELSAD)

}
\seealso{
\code{qm_define}, \code{qm_validate}
}
