


//******************************************************************************************

#include <R.h>
#include <Rmath.h>
#include <math.h>
#include <R_ext/Random.h>
#include <stdio.h>
#include <time.h>

//*******************************************************************************************
// these are global parameters, which values have been generated by the previous steps

int CROSS;         // cross type 0:RILs, 1:BC, 2:F2
int NG;            // number of genotypes
int NLG;           // number of chromosomes
int NS;            // number of individuals 
double **GRID;     // grid points
double ****QPROB;  // genotype probabilities for each individual at each grid

int TNGRID;        // total number of grids
int *NGRID;        // number of grids at each chromosome
int CHL;           // max number of grids 

int NS1;           // number of individuals 

//*****************************************************************************************
// these parameters are passed from R function bmq.mcmc

double *Y;             // phenotypic data
int CATEGORY;          // 1: normal data; 2: binary data; 3:ordinal data
int CN;                // Categories # for binary or ordinal data

int NITER;             // Number of iterations
int NTHIN;             // Thinning value
int NBURNIN;            // Burnin
int VERBOSE;           // Verbose

int GIBBS;             // 1: Gibbs scaning all effects; 0: Kohn's M-H method for MCMC algorithm
int UPDATEGENO;        // 1: update QTL genotypes; 0: doesn't update QTL genotype

int EPISTASIS;         // 1: epistatic model; 0: non-epistatic model;
int E_NQTL_MAIN;    // expected number of main-effect QTL 
int E_NQTL;         // expected number of all QTL 
int NQTL;              // max QTL #  

double *DQQ;            // distance between flanking two genes 
int *CHR_NQTL;         // max QTL # at each chromosome

int ENV_FACTOR;        // 1:include environmental factors-need to fix this
int GBYE;              // 1: include g by e interactions
int NRANCOVA;          // random effects #
int NFIXCOVA;          // fixed effects # 
int *GBYE_FIX_INDEX;   // indicating which fixed covariates are treated in g-by-e
int *NRAN;             // random effect #
double **COEF_RAN;     // random covariates
double **COEF_FIX;      // fixed covariates

int DEPENDENCE;        // see Chipman's paper
double *C;             // see Chipman's paper 

int SEED;		      // the pseudo-random number generator

//********************************************************************************
 
int GROUP;             // 1: groupedly update all main effects or epistatic effects
int NC;                // the number of main effects at one QTL

int SPH;               // 1: standardized phenotype; 0: original phenotype

//********************************************************************************
// for binary and ordinal traits

int *W;                // ordinal or binary phenotype
double *CUTPOINT;      // threshold values for ordinal traits

//********************************************************************************
// parameters used in prior specification

double W_MAIN;          // prior for main effect indicator
double W_EPISTASIS;     // prior for epistatic effect indicator
double W_GBYE;          // prior for g by e indicator
double  *VMAIN;         // prior variance of main effects
double **VEPISTASIS;    // prior variance of epistatic effects
double **V_GBYE_FIX;    // prior variance of g-by-e effects

//*********************************************************************************
// genetic model parameters

double AMU;             // overall mean
double VE;              // residual variance
double  **MAIN;         // main effects
double ****EPISTATIC;   // epistatic effects

double *GVALUE;         // genotypic valyes
int **GENO;             // QTL genotypes
double ***COEF;         // coefficients of QTL main effects

//*********************************************************************************
// QTL positions, genetic effects indicators

int *QLOC;             // QTL position indicators, position is GRID[QCHR[L]][QLOC[L]] 
int *QCHR;             // chromosomes that QTL locate
int *CHRQTL;           // QTL number at each chromosome 

int *GAMMA;            // QTL indicators
int *GAMMA_MAIN;       // main effects indicators
int **GAMMA_EPISTASIS; // epistatic effects indicators 

//**********************************************************************************
// environmental covariate parameters

double  *FIX;         // effects of fixed covariates 
double  **RAN;        // effects of random covariates
double  *VRAN;        // variances of random covariates
double ***GBYE_FIX;   // interactions of QTL main effects and fixed covariates
double  **GAMMA_GBYE; // g-by-e indicators

//***********************************************************************************

double PDD1, PDD2;
double *PD1, *PD2;

int IBD;

double  *X;

//*************************************************************************************************************

char iterfile[100];
char pairfile[100];
char mainfile[100];
char gbyefile[100];
char covfile[100];
 
//*****************************************************************************************************
void R_AnalysisEngine(int *nind,int *nchr,int *ngen, int *nloci,double *loci,double *prob,
					  double *yvalue,int *traittype,int *ncategory,
					  int *iter,int *thin,int *burnin,
                      int *algorithm,int *genoupdate,
                      int *epis,int *emainqtl,int *eqtl,int *mnqtl,
					  double *interval,int *chrnqtl,
					  int *envi,int *qtl_envi,int *nrancov,int *nfixcov,int *intcov,double *rancoef,double *fixcoef,int *nran,
					  int *depen,double *prop,int *seed,
		      int *verbose); 

//******************************************************************
// C functions included  
  
double RANDOM();

void ANORMAL(double *R1,double *R2);

void MULTINORMAL(double * PRIOR);

double NormalFunction(double X);

double TrunNormal(int WW,double B,double V);

double Likelihood(double *p,double *G);

void Coefficient(int GENOTYPE);

void Coefficient0(int I,int L,int QL);

double GenotypeSampling(int I,int L,int II,int QL);

void Mean(double YBAR,double VP);

void ResidualVariance(double VP);

void MainEffect(int L);

void EpistaticEffect(int L1,int L2);

void GBYE_FixedCovariate(int L1,int L2);

void MainVariance(double VP);

void EpistaticVariance(double VP);

void GBYE_FixedCovariate_Variance(int L1,double VP);

void FixedCovariate(int L);

void RandomCovariate(int L);

void RanVariance(int L,double VP);

void QTLgenotype(int L,int NL,int QL,int I);

void QTLINHERITANCE(int L,int I);

void QTLPOSITION(int L,int QLNEW);

int SamplingOnePosition(int L);

void ZeroEffect();
void ZeroEffect1(int L);
void ZeroEffect2(int L1,int L2);

void MainEffectIndicator_GROUP0(int L,int K);

void MainEffectIndicator_GROUP1(int L);

void EpistasisIndicator_GROUP0(int L1,int L2,int K1,int K2);

void EpistasisIndicator_GROUP1(int L1,int L2);

void GBYE_FIX_Indicator_GROUP0(int L1,int L2,int K);

void GBYE_FIX_Indicator_GROUP1(int L1,int L2);

//******************************************************************

void bmqAnalysis();


