% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/process_inputs.R
\name{process_inputs}
\alias{process_inputs}
\title{Process inputs to scan functions}
\usage{
process_inputs(
  probs,
  pheno,
  addcovar,
  kinship,
  n_snp = dim(probs)[3],
  start_snp = 1,
  max_iter = 10^4,
  max_prec = 1/10^8
)
}
\arguments{
\item{probs}{a three-dimensional array of founder allele probabilities}

\item{pheno}{a matrix of d trait values}

\item{addcovar}{a matrix of covariates}

\item{kinship}{a kinship matrix}

\item{n_snp}{number of markers}

\item{start_snp}{index number of start position in the probs object.}

\item{max_iter}{max number of iterations for EM}

\item{max_prec}{max precision for stopping EM}
}
\description{
Process inputs to scan functions
}
