% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/color_patterns.R
\name{color_patterns_set}
\alias{color_patterns_set}
\title{Set up colors for patterns or points}
\usage{
color_patterns_set(
  scan1output,
  snpinfo,
  patterns,
  col,
  pattern,
  show_all_snps,
  col_hilit,
  drop_hilit,
  maxlod
)
}
\arguments{
\item{scan1output}{output of linear mixed model for \code{phename} (see \code{\link[qtl2]{scan1}})}

\item{snpinfo}{Data frame with snp information}

\item{patterns}{Connect SDP patterns: one of \code{c("none","all","hilit")}.}

\item{col}{Color of other points, or colors for patterns}

\item{pattern}{allele pattern as of form \code{AB:CDEFGH}}

\item{show_all_snps}{show all SNPs if \code{TRUE}}

\item{col_hilit}{Color of highlighted points}

\item{drop_hilit}{SNPs with LOD score within this amount of the maximum SNP association will be highlighted.}

\item{maxlod}{Maximum LOD for drop of \code{drop_hilit}}
}
\value{
list of \code{col} and \code{pattern}.
}
\description{
Set up colors for patterns or points
}
