% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_csv.R
\name{read_csv}
\alias{read_csv}
\title{Read a csv file}
\usage{
read_csv(
  filename,
  sep = ",",
  na.strings = c("NA", "-"),
  comment.char = "#",
  transpose = FALSE,
  rownames_included = TRUE
)
}
\arguments{
\item{filename}{Name of input file}

\item{sep}{Field separator}

\item{na.strings}{Missing value codes}

\item{comment.char}{Comment character; rest of line after this character is ignored}

\item{transpose}{If TRUE, transpose the result}

\item{rownames_included}{If TRUE, the first column is taken to be row names.}
}
\value{
Data frame
}
\description{
Read a csv file via \code{\link[data.table:fread]{data.table::fread()}} using a
particular set of options, including the ability to transpose the
result.
}
\details{
Initial two lines can contain comments with number of rows
and columns. Number of columns includes an ID column; number of
rows does not include the header row.

The first column is taken to be a set of row names
}
\examples{
\dontrun{mydata <- read_csv("myfile.csv", transpose=TRUE)}
}
\seealso{
\code{\link[=read_csv_numer]{read_csv_numer()}}
}
