% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_coef.R
\name{plot_coef}
\alias{plot_coef}
\alias{plot_coefCC}
\alias{plot.scan1coef}
\title{Plot QTL effects along chromosome}
\usage{
plot_coef(
  x,
  map,
  columns = NULL,
  col = NULL,
  scan1_output = NULL,
  add = FALSE,
  gap = NULL,
  top_panel_prop = 0.65,
  legend = NULL,
  ...
)

plot_coefCC(
  x,
  map,
  columns = 1:8,
  scan1_output = NULL,
  add = FALSE,
  gap = NULL,
  top_panel_prop = 0.65,
  legend = NULL,
  ...
)

\method{plot}{scan1coef}(
  x,
  map,
  columns = 1,
  col = NULL,
  scan1_output = NULL,
  add = FALSE,
  gap = NULL,
  top_panel_prop = 0.65,
  legend = NULL,
  ...
)
}
\arguments{
\item{x}{Estimated QTL effects ("coefficients") as obtained from
\code{\link[=scan1coef]{scan1coef()}}.}

\item{map}{A list of vectors of marker positions, as produced by
\code{\link[=insert_pseudomarkers]{insert_pseudomarkers()}}.}

\item{columns}{Vector of columns to plot}

\item{col}{Vector of colors, same length as \code{columns}. If
NULL, some default choices are made.}

\item{scan1_output}{If provided, we make a two-panel plot with
coefficients on top and LOD scores below. Should have just one LOD
score column; if multiple, only the first is used.}

\item{add}{If TRUE, add to current plot (must have same map and
chromosomes).}

\item{gap}{Gap between chromosomes. The default is 1\% of the total genome length.}

\item{top_panel_prop}{If \code{scan1_output} provided, this gives the
proportion of the plot that is devoted to the top panel.}

\item{legend}{Location of legend, such as \code{"bottomleft"} or \code{"topright"} (NULL for no legend)}

\item{...}{Additional graphics parameters.}
}
\value{
None.
}
\description{
Plot estimated QTL effects along a chromosomes.
}
\details{
\code{plot_coefCC()} is the same as \code{plot_coef()}, but forcing
\code{columns=1:8} and using the Collaborative Cross colors,
\link{CCcolors}.
}
\section{Hidden graphics parameters}{

A number of graphics parameters can be passed via \code{...}. For
example, \code{bgcolor} to control the background color, and things
like \code{ylab} and \code{ylim}. These are not included as formal
parameters in order to avoid cluttering the function definition.

In the case that \code{scan1_output} is provided, \code{col},
\code{ylab}, and \code{ylim} all control the panel with estimated
QTL effects, while \code{col_lod}, \code{ylab_lod}, and
\code{ylim_lod} control the LOD curve panel.

If \code{legend} is indicated so that a legend is shown, \code{legend_lab}
controls the labels in the legend, and \code{legend_ncol} indicates the
number of columns in the legend.
}

\examples{
# read data
iron <- read_cross2(system.file("extdata", "iron.zip", package="qtl2"))

# insert pseudomarkers into map
map <- insert_pseudomarkers(iron$gmap, step=1)

# calculate genotype probabilities
probs <- calc_genoprob(iron, map, error_prob=0.002)

# grab phenotypes and covariates; ensure that covariates have names attribute
pheno <- iron$pheno[,1]
covar <- match(iron$covar$sex, c("f", "m")) # make numeric
names(covar) <- rownames(iron$covar)

# calculate coefficients for chromosome 7
coef <- scan1coef(probs[,7], pheno, addcovar=covar)

# plot QTL effects (note the need to subset the map object, for chromosome 7)
plot(coef, map[7], columns=1:3, col=c("slateblue", "violetred", "green3"))
}
\seealso{
\link{CCcolors}, \code{\link[=plot_scan1]{plot_scan1()}}, \code{\link[=plot_snpasso]{plot_snpasso()}}
}
