% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/batch_cols.R
\name{batch_cols}
\alias{batch_cols}
\title{Batch columns by pattern of missing values}
\usage{
batch_cols(mat, max_batch = NULL)
}
\arguments{
\item{mat}{A numeric matrix}

\item{max_batch}{Maximum batch size}
}
\value{
A list containing the batches, each with two components:
\code{cols} containing numeric indices of the columns in the
corresponding batch, and \code{omit} containing a vector of row indices
that have missing values in this batch.
}
\description{
Identify batches of columns of a matrix that have the same pattern
of missing values.
}
\examples{
x <- rbind(c( 1,  2,  3, 13, 16),
           c( 4,  5,  6, 14, 17),
           c( 7, NA,  8, NA, 18),
           c(NA, NA, NA, NA, 19),
           c(10, 11, 12, 15, 20))
batch_cols(x)
}
\seealso{
\code{\link[=batch_vec]{batch_vec()}}
}
