% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_archive_data.R
\name{get_archive_data}
\alias{get_archive_data}
\title{Download an archive file and unarchive its contents}
\usage{
get_archive_data(url, target_dir, force = FALSE, confirmed = FALSE)
}
\arguments{
\item{url}{A character vector representing the full url to
the compressed file}

\item{target_dir}{The directory where the archive file should be downloaded}

\item{force}{An optional argument which forcefully overwrites existing data}

\item{confirmed}{If \code{TRUE}, the user has confirmed that they have
permission to use the data.
If \code{FALSE}, the function will prompt the user to confirm permission.
Setting this to \code{TRUE} is useful for reproducible workflows.}
}
\value{
NULL, the archive file is unarchived in the target directory
}
\description{
Possible file types include .zip, .gz, .tar, and .tgz
}
\examples{
test_dir <- file.path(tempdir(), "test")
url <- "https://raw.githubusercontent.com/qtalr/qtkit/main/inst/extdata/test_data.zip"
get_archive_data(
 url = url,
 target_dir = test_dir,
 confirmed = TRUE
)
}
