% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qs_savem.R
\name{qs_readm}
\alias{qs_readm}
\title{qs_readm}
\usage{
qs_readm(file, env = parent.frame(), ...)
}
\arguments{
\item{file}{The file name/path.}

\item{env}{The environment where the data should be loaded. Default is the calling environment (\code{\link[=parent.frame]{parent.frame()}}).}

\item{...}{additional arguments will be passed to \link{qs_read}.}
}
\value{
Nothing is explicitly returned, but the function will load the saved objects into the workspace.
}
\description{
Reads an object in a file serialized to disk using \code{\link[=qs_savem]{qs_savem()}}.
}
\details{
This function extends \link{qs_read} to replicate the functionality of \code{\link[base:load]{base::load()}} to load multiple saved objects into your workspace.
}
\examples{
x1 <- data.frame(int = sample(1e3, replace=TRUE),
                 num = rnorm(1e3),
                 char = sample(starnames$`IAU Name`, 1e3, replace=TRUE),
                 stringsAsFactors = FALSE)
x2 <- data.frame(int = sample(1e3, replace=TRUE),
                 num = rnorm(1e3),
                 char = sample(starnames$`IAU Name`, 1e3, replace=TRUE),
                 stringsAsFactors = FALSE)
myfile <- tempfile()
qs_savem(x1, x2, file=myfile)
rm(x1, x2)
qs_readm(myfile)
exists('x1') && exists('x2') # returns true
}
