% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qs_savem.R
\name{qs_savem}
\alias{qs_savem}
\title{qs_savem}
\usage{
qs_savem(...)
}
\arguments{
\item{...}{Objects to serialize. Named arguments will be passed to \code{\link[=qs_save]{qs_save()}} during saving. Un-named arguments will be saved. A named \code{file} argument is required.}
}
\description{
Saves (serializes) multiple objects to disk.
}
\details{
This function extends \code{\link[=qs_save]{qs_save()}} to replicate the functionality of \code{\link[base:save]{base::save()}} to save multiple objects. Read them back with \code{\link[=qs_readm]{qs_readm()}}.
}
\examples{
x1 <- data.frame(int = sample(1e3, replace=TRUE),
                 num = rnorm(1e3),
                 char = sample(starnames$`IAU Name`, 1e3, replace=TRUE),
                 stringsAsFactors = FALSE)
x2 <- data.frame(int = sample(1e3, replace=TRUE),
                 num = rnorm(1e3),
                 char = sample(starnames$`IAU Name`, 1e3, replace=TRUE),
                 stringsAsFactors = FALSE)
myfile <- tempfile()
qs_savem(x1, x2, file=myfile)
rm(x1, x2)
qs_readm(myfile)
exists('x1') && exists('x2') # returns true
}
