% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qrsvm.R
\name{qrsvm}
\alias{qrsvm}
\title{Fits a quantile regression SVM based on the Pinball Loss}
\usage{
qrsvm(x, y, kernel = "rbfdot", cost = 1, tau = 0.95, sigma = 5,
  degree = 2, scale = 1, offset = 1, order = 1)
}
\arguments{
\item{x}{An n X m matrix containing the predictors (n= number of observatiosn, m = number of predictors) .}

\item{y}{The Response onto which the qrsvm shall be fitted}

\item{kernel}{a string giving the type of kernels from package kernlab to use f.e. "rbfdot" for Radial Basis Function Kernel. All Kernels except "stringdot" supported.}

\item{cost}{The Cost parameter see f.e. package "e1071" and "kernlab"}

\item{tau}{The Quantile that shall be estimated. 0<=tau<=1}

\item{sigma}{A possible tuning parameter for specific Kernelfunctions, see package kernlab.}

\item{degree}{A possible tuning parameter for specific Kernelfunctions, see package kernlab.}

\item{scale}{A possible tuning parameter for specific Kernelfunctions, see package kernlab.}

\item{offset}{A possible tuning parameter for specific Kernelfunctions, see package kernlab.}

\item{order}{A possible tuning parameter for specific Kernelfunctions, see package kernlab.}
}
\value{
An object of class "qrsvm"
}
\description{
Fits a quantile regression SVM based on the Pinball Loss
}
\details{
There is no preimplemented scaling of the input variables which should be considered beforehand. Also optimization is based on "quadprog:solve.QP" function which can be considerably slow compared to other SVM implementations.
}
\examples{
n<-200

x<-as.matrix(seq(-1.5,1.5,length.out = n))
y<-rnorm(n)*(0.3+abs(sin(x)))

plot(x,y)

mod005<-qrsvm(x,y, tau=0.05)
mod095<-qrsvm(x,y, tau=0.95)
lines(x, mod005$fitted, col="red")
lines(x, mod095$fitted, col="red")
}
\references{
"Nonparametric Quantile Regression" by I.Takeuchi, Q.V. Le, T. Sears, A.J. Smola (2004)
}
