% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/graphSum.R
\name{graphSum}
\alias{graphSum}
\title{Draw graphs of insect mortality or other exposure-response data}
\usage{
graphSum(
  df,
  subSet = NULL,
  link = "cloglog",
  logScale = FALSE,
  dead = "Dead",
  tot = "Tot",
  dosevar = "logCT",
  Rep = "Rep",
  fitRep = NULL,
  fitPanel = NULL,
  byFacet = ~Species,
  layout = NULL,
  maint = "Codling Moth, MeBr",
  ptSize = 2,
  xzeroOffsetFrac = 0.08,
  yzeroOneOffsets = c(-0.08, 0.08),
  yEps = 0.005,
  xlab = expression(bold("CT ") * "(gm.h." * m^{     -3 } * ")"),
  ylabel = NULL,
  ytiklab = c(0.01, 0.05, 0.1, 0.25, 0.5, 0.75, 0.9, 0.99)
)
}
\arguments{
\item{df}{Data frame from which data will be taken}

\item{subSet}{NULL, or an expression, such  as for example
\code{expression(LifeStage=='Eggs')}) that evaluates to a logical that
specifies the required data subset.  If not NULL then the subsetting
information is pasted on after the main title}

\item{link}{Link function. If character, obtain from \code{\link{make.link}}.
Alternatively, a function may be supplied as argument.}

\item{logScale}{Logical, indicating whether the dose ($x$-variable)
is on a log scale.}

\item{dead}{Character; name of column holding number dead}

\item{tot}{Character; column holding total number}

\item{dosevar}{Character; column holding "dose" values}

\item{Rep}{Character; NULL, or column holding replicate number, within panel}

\item{fitRep}{Character; NULL, or column holding replicate fitted values}

\item{fitPanel}{Character; NULL, or column holding panel fitted values}

\item{byFacet}{Graphics formula specifying factor combination that
determines panel}

\item{layout}{Graphics formula that can be supplied to \code{grid_facet}}

\item{maint}{Main title}

\item{ptSize}{Pointsize, by default 2}

\item{xzeroOffsetFrac}{$x$-axis zero offset fraction, required when
scale is logarithmic}

\item{yzeroOneOffsets}{Length two vector, giving 0% mortality and
100% mortality offsets, as fractions of the range for other
mortalities, on the scale of the link function.}

\item{yEps}{Fractional increase at bottom and top of $y$ user range
to accommodate points for mortalities of 0 and 1.}

\item{xlab}{Expression specifying x-axis label}

\item{ylabel}{If not \code{NULL}, $y$-axis label}

\item{ytiklab}{Place $y$ axis tiks and labels at these mortalities}
}
\value{
{No return value, called for side effects}
}
\description{
Datasets that are in mind hold, for each replicate of
each combination of each of a several factors (e.g.,
species, lifestages, temperatures), mortalities for
each of a number of values of "dose".  See for example
the dataset help page \code{\link[qra]{codling1989}}.
}
