% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/crude_mx_sh3.R
\name{crude_mx_sh3}
\alias{crude_mx_sh3}
\title{Data frame(s) of crude estimates of quarterly (and annual) central rates of mortality estimated using shortcut 3.}
\usage{
crude_mx_sh3(
  pop.start,
  pop.end,
  events.death,
  events.out,
  events.in,
  annual = FALSE
)
}
\arguments{
\item{pop.start}{A data frame, corresponding to the target population/portfolio, containing by age the stock of
population/portfolio by quarter collected at the beginning of the year. This data frame must
have three columns. The first refers to integer ages (e.g., 20, 21, 22,...),
the second to the quarter (with values 1, 2, 3 and 4) and the third to the number of people in
the population/portfolio at the beginning of the year corresponding to each integer age and quarter.}

\item{pop.end}{A data frame, corresponding to the target population/portfolio, containing by age the
stock of population/portfolio by quarter collected at the end of the year. This data frame must
have three columns. The first refers to integer ages (e.g., 20, 21, 22,...),
the second to the quarter (with values 1, 2, 3 and 4) and the third to the number of people in
the population/portfolio at the end of the year corresponding to each integer age and quarter.}

\item{events.death}{A data frame with the number of deaths recorded in the population/portfolio
during the target year in a set of integer ages for each combination of age
and season/calendar quarter. Typically, this is an output of the function
\code{\link{count_events_quarter}} or a data frame with the same structure.
If the range of ages in `events.death` does not cover the range of ages in the intersection of
ages defined by `pop.start` and `pop.end`, zeros are imputed for the missing ages.}

\item{events.out}{A data frame with the number of exits (emigrants/lapses/expirations) recorded in
the population/portfolio during the target year in a set of integer ages for each combination of
age and season/calendar quarter. Typically, this is an output of the function
\code{\link{count_events_quarter}} or a data frame with the same structure.
If the range of ages in `events.out` does not cover the range of ages in the intersection of
ages defined by `pop.start` and `pop.end`, zeros are imputed for the missing ages.}

\item{events.in}{A data frame with the number of entries (immigrants/new policies) recorded in
the population/portfolio during the target year in a set of integer ages for each combination of
age and season/calendar quarter. Typically, this is an output of the function
\code{\link{count_events_quarter}} or a data frame with the same structure.
If the range of ages in `events.in` does not cover the range of ages in the intersection of
ages defined by `pop.start` and `pop.end`, zeros are imputed for the missing ages.}

\item{annual}{A character string informing whether the annual crude central rates of mortality
should also be computed. Default, `FALSE`.}
}
\value{
When `annual = FALSE` a data frame with estimated crude central rates of mortality for each combination of age and
calendar quarter in the set of integer ages determined by the intersection of ages in `pop.start` and `pop.end`.
The data frame has the following components:
   \item{age}{ Integer age to which the crude central rate of mortality corresponds.}
   \item{quarter.age}{ Age quarter to which the crude central rate of mortality corresponds.}
   \item{quarter.calendar}{ Calendar (time, season) quarter to which the crude central rate of mortality corresponds.}
   \item{exposed}{ Total exposure-at-risk times in the target population, calulated according to shortcut 2, for each combination of `age`, `quarter.age` and `quarter.calendar`.}
   \item{deaths}{ Number of deaths in the target population for each  combination of `age`, `quarter.age` and `quarter.calendar`.}
   \item{mx}{ Estimated crude central rate of mortality corresponding to the combination of `age`, `quarter.age` and `quarter.calendar`.}
When `annual = TRUE` the output is a list with two data frames `mx.quarterly` and `mx.annual`.
`mx.quarterly` is a data frame with the estimated quarterly crude central rates of mortality as just described and
`mx.annual` is the corresponding data frame with the estimated annual crude central rates of mortality.
}
\description{
Computes for a general/insured population crude estimates of quarterly (and annual)
              central rates of mortality by age (in a set of integer ages) for each combination
              of age and calendar quarter, using quarterly age aggregated data of population stocks and age-season
              quarterly counts of deaths, immigrants/new policies (entries) and emigrants/lapses/expirations (exits)
              by employing shortcut 3, based on equation (2.9), proposed in Pavia and Lledo (2023).
}
\note{
It is the responsibility of the user to assure that both stocks of population (which determine the ages for
which estimates are computed) and number of events correspond to the same year.
}
\examples{
\donttest{
# This can take a while
 pop <- 2005 - as.numeric(substr(pop_2006$date.birth, 1 , 4))
 pop <- as.data.frame(table(pop))
 pop[, 1] <- as.numeric(as.character(pop[, 1]))
 pop[, 2] <- pop[, 2]/4
 pop <- cbind(apply(pop, 2, rep, each = 4), quarter = rep(1:4, nrow(pop)))[, c(1, 3, 2)]
 pop <- as.data.frame(pop)
 temp <- quarterly_variables(death_2006$date.birth, death_2006$date.death)
 e.death <- count_events_quarter(temp)
 temp <- quarterly_variables(emi_2006$date.birth, emi_2006$date.emi)
 e.emi <- count_events_quarter(temp)
 temp <- quarterly_variables(immi_2006$date.birth, immi_2006$date.immi)
 e.immi <- count_events_quarter(temp)
 out <- crude_mx_sh3(pop, pop, e.death, e.emi, e.immi)
}
pop.1 <- data.frame(age = c(rep(40, 4), rep(41, 4)), quarter = rep(1:4, 2), people = c(4134, 4353))
pop.2 <- data.frame(age = c(rep(40, 4), rep(41, 4)), quarter = rep(1:4, 2), people = c(4250, 4213))
dates.b <- c("1980-04-12")
dates.d <- c("2020-08-23")
x <- quarterly_variables(dates.b, dates.d)
e.death <- count_events_quarter(x)
dates.b <- c("1980-05-12")
dates.e <- c("2020-06-23")
x <- quarterly_variables(dates.b, dates.e)
e.emi <- count_events_quarter(x)
dates.b <- c("1980-07-12")
dates.i <- c("2020-12-10")
x <- quarterly_variables(dates.b, dates.i)
e.immi <- count_events_quarter(x)
out <- crude_mx_sh3(pop.1, pop.2, e.death, e.emi, e.immi)
}
\references{
Pavia, JM and Lledo, J (2023). Shortcuts for the construction of sub-annual life tables. *ASTIN Bulletin: The Journal of the International Actuarial Association*, 53(2), 332-350. \doi{10.1017/asb.2023.16}
}
\seealso{
\code{\link{crude_mx}}, \code{\link{crude_mx_sh2}}.
}
\author{
Jose M. Pavia \email{pavia@uv.es}

Josep Lledo \email{josep.lledo@uv.es}
}
