% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/time_exposed_ins.R
\name{time_exposed_ins}
\alias{time_exposed_ins}
\title{Data frame of time exposed at risk for a population of immigrants/portfolio entries}
\usage{
time_exposed_ins(x)
}
\arguments{
\item{x}{A data.frame output of the \code{\link{quarterly_variables}} function.}
}
\value{
A data frame with the time exposed at risk for each (potential) combination of integer age and age and
season quarter of the input dataset. The data frame has the following components:
   \item{age}{ Integer age to which the time exposed at risk corresponds.}
   \item{quarter.age}{ Age quarter to which the time exposed at risk corresponds.}
   \item{quarter.calendar}{ Calendar (time, season) quarter to which the time exposed at risk corresponds.}
   \item{time.exposed}{ Total time (in years) exposed at risk of the population during the quarter determined for the
                        combination of `age`, `quarter.age` and `quarter.calendar`.}
}
\description{
Computes for each integer age and each combination of age and seasonal quarter
              the total time exposed at risk (in years) of a population of immigrants/new policies
              (new production) during the year of the event.
              The computation is performed using the associated data frame of quarterly variables
              corresponding to the population obtained using the \code{\link{quarterly_variables}} function.
}
\note{
The time exposed at risk is computed for each death from the beginning of the year in which the event occurred
until the moment of occurrence of the event. Please see the note in the \code{\link{time_exposed_stock}} function.
}
\examples{
dates.b <- c("1920-05-13", "1999-04-12", "2019-01-01")
dates.e <- c("2002-03-23", "2009-04-12", "2019-01-01")
x <- quarterly_variables(dates.b, dates.e)
out <- time_exposed_ins(x)
}
\references{
Pavia, JM and Lledo, J (2022). Estimation of the Combined Effects of Ageing and Seasonality on Mortality Risk. An application to Spain. *Journal of the Royal Statistical Society, Series A (Statistics in Society)*, 185(2), 471-497. \doi{10.1111/rssa.12769}
}
\seealso{
\code{\link{time_exposed_stock}}, \code{\link{time_exposed_outs}}, \code{\link{time_exposed_newborns}}
}
\author{
Josep Lledo \email{josep.lledo@uv.es}

Jose M. Pavia \email{pavia@uv.es}
}
