% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/tcc.R
\name{plot.tcc}
\alias{plot.tcc}
\title{Plot trellis control chart}
\usage{
\method{plot}{tcc}(x, y = NULL, cex = 1, pex = 1, ylim = NULL,
  date.format = "\%Y-\%m-\%d", flip = FALSE, dots.only = FALSE, ...)
}
\arguments{
\item{x}{List object returned from the tcc() function.}

\item{y}{Ignored. Included for compatibility with generic plot function.}

\item{cex}{Number indicating the amount by which text should be magnified.}

\item{pex}{Number indicating the amount by which plotting symbols should be
magnified.}

\item{ylim}{Range of y axis.}

\item{date.format}{Date format of x axis labels. See \code{?strftime} for
date formats.}

\item{flip}{Logical. If TRUE rotates the plot 90 degrees.}

\item{dots.only}{Logical value. If TRUE, data points are not connected by
lines and runs analysis is not performed. Useful for comparison and funnel
plots.}

\item{...}{Further arguments to plot function.}
}
\value{
Creates a tcc plot.
}
\description{
Creates a plot of a tcc object
}
\examples{
p <- tcc(rnorm(24))
plot(p)
}

