% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/genomic_bayes.R
\name{adjustMapLD}
\alias{adjustMapLD}
\title{Adjust Linkage Disequilibrium (LD) Using Map Information}
\usage{
adjustMapLD(LD = NULL, map = NULL, neff = 11600, nmap = 186, threshold = 0.001)
}
\arguments{
\item{LD}{A matrix representing the linkage disequilibrium (LD) structure.}

\item{map}{A numeric vector containing the map information.}

\item{neff}{An integer representing the effective population size. Default is 11600.}

\item{nmap}{An integer representing the sample size used for map construction. Default is 186.}

\item{threshold}{A numeric value specifying the threshold for setting LD to zero. Currently unused in the function. Default is 0.001.}
}
\value{
A matrix where each value is the adjusted LD based on the input map, effective population size, and map construction sample size.
}
\description{
Adjusts the linkage disequilibrium (LD) values based on map information, effective population size,
and sample size used for map construction.
}
\keyword{internal}
