% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/genomic_score.R
\name{gscore}
\alias{gscore}
\title{Genomic scoring based on single marker summary statistics}
\usage{
gscore(
  Glist = NULL,
  chr = NULL,
  bedfiles = NULL,
  bimfiles = NULL,
  famfiles = NULL,
  stat = NULL,
  fit = NULL,
  ids = NULL,
  scale = TRUE,
  impute = TRUE,
  msize = 100,
  ncores = 1,
  verbose = FALSE
)
}
\arguments{
\item{Glist}{list of information about genotype matrix}

\item{chr}{chromosome for which genomic scores is computed}

\item{bedfiles}{name of the PLINK bed-files}

\item{bimfiles}{name of the PLINK bim-files}

\item{famfiles}{name of the PLINK fam-files}

\item{stat}{matrix of single marker effects}

\item{fit}{fit object output from gbayes}

\item{ids}{vector of individuals used in the analysis}

\item{scale}{logical if TRUE the genotype markers have been scale to mean zero and variance one}

\item{impute}{logical if TRUE missing genotypes are set to its expected value (2*af where af is allele frequency)}

\item{msize}{number of genotype markers used for batch processing}

\item{ncores}{number of cores used in the analysis}

\item{verbose}{is a logical; if TRUE it prints more details during optimization}
}
\description{
The gscore function is used for genomic predictions based on single marker summary statistics
(coefficients, log-odds ratios, z-scores) and observed genotypes.
}
\examples{

 ## Plink bed/bim/fam files
 bedfiles <- system.file("extdata", paste0("sample_chr",1:2,".bed"), package = "qgg")
 bimfiles <- system.file("extdata", paste0("sample_chr",1:2,".bim"), package = "qgg")
 famfiles <- system.file("extdata", paste0("sample_chr",1:2,".fam"), package = "qgg")
 
 # Summarize bed/bim/fam files
 Glist <- gprep(study="Example", bedfiles=bedfiles, bimfiles=bimfiles, famfiles=famfiles)
 
 # Simulate phenotype
 sim <- gsim(Glist=Glist, chr=1, nt=1)
 
 # Compute single marker summary statistics
 stat <- glma(y=sim$y, Glist=Glist, scale=FALSE)
 
 # Compute genomic scores
 gsc <- gscore(Glist = Glist, stat = stat)
 
}
\author{
Peter Soerensen
}
