% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compute_grm.R
\name{grm}
\alias{grm}
\title{Computing the genomic relationship matrix (GRM)}
\usage{
grm(Glist = NULL, GRMlist = NULL, ids = NULL, rsids = NULL,
  rws = NULL, cls = NULL, W = NULL, method = "add", scale = TRUE,
  msize = 100, ncores = 1, fnG = NULL, overwrite = FALSE,
  returnGRM = FALSE, miss = 0, task = "grm")
}
\arguments{
\item{Glist}{list providing information about genotypes stored on disk}

\item{GRMlist}{list providing information about GRM matrix stored in binary files on disk}

\item{ids}{vector of individuals used for computing GRM}

\item{rsids}{vector marker rsids used for computing GRM}

\item{rws}{rows in genotype matrix used for computing GRM}

\item{cls}{columns in genotype matrix used for computing GRM}

\item{W}{matrix of centered and scaled genotypes}

\item{method}{indicator of method used for computing GRM: additive (add, default), dominance (dom) or epistasis (epi-pairs or epi-hadamard (all genotype markers))}

\item{scale}{logical if TRUE the genotypes in Glist has been scaled to mean zero and variance one}

\item{msize}{number of genotype markers used for batch processing}

\item{ncores}{number of cores used to compute the GRM}

\item{fnG}{name of the binary file used for storing the GRM on disk}

\item{overwrite}{logical if TRUE the binary file fnG will be overwritten}

\item{returnGRM}{logical if TRUE function returns the GRM matrix to the R environment}

\item{miss}{the missing code (miss=0 is default) used for missing values in the genotype data}

\item{task}{either computation of GRM (task="grm"  which is default) or eigenvalue decomposition of GRM (task="eigen")}
}
\value{
Returns a genomic relationship matrix (GRM) if returnGRM=TRUE else a list structure (GRMlist) with information about the GRM  stored on disk
}
\description{
The grm function is used to compute a genomic relationship matrix (GRM) based on all,
or a subset of marker genotypes. GRM for additive, and non-additive (dominance and
epistasis) genetic models can be constructed. The output of the grm function can either be a
within-memory GRM object (n x n matrix), or a GRM-list which is a list structure that
contains information about the GRM stored in a binary file on the disk.
}
\examples{

# Simulate data
W <- matrix(rnorm(1000000), ncol = 1000)
	colnames(W) <- as.character(1:ncol(W))
	rownames(W) <- as.character(1:nrow(W))

# Compute GRM
GRM <- grm(W = W)

\donttest{

# Eigen value decompostion GRM
eig <- grm(GRM=GRM, task="eigen")

}
}
\author{
Peter Soerensen
}
