% Generated by roxygen2 (4.0.2): do not edit by hand
\name{cm_code.exclude}
\alias{cm_code.exclude}
\title{Exclude Codes}
\usage{
cm_code.exclude(x2long.obj, exclude.code.list, rm.var = NULL)
}
\arguments{
\item{x2long.obj}{An object from \code{\link[qdap]{cm_range2long}},
\code{\link[qdap]{cm_time2long}} or \code{\link[qdap]{cm_df2long}}.}

\item{exclude.code.list}{A list of named character vectors of at least two
code column names to compare and exclude.  The last column name is the one
that will be excluded.}

\item{rm.var}{Name of the repeated measures column.}
}
\value{
Returns a dataframe with n codes excluding the nth code.
}
\description{
Find the occurrences of n codes excluding the nth code.  For example you have
times/words coded for a teacher and you also have times/words coded for
happiness.  You can find all the happiness times excluding the teacher times
or vice versa.
}
\note{
The code column must be named \code{"code"} and your start and end
columns must be named \code{"start"} and \code{"end"}.
}
\examples{
\dontrun{
foo <- list(
    AA = qcv(terms="1:10"),
    BB = qcv(terms="1:2, 3:10, 19"),
    CC = qcv(terms="1:3, 5:6")
)

foo2  <- list(
    AA = qcv(terms="4:8"),
    BB = qcv(terms="1:4, 10:12"),
    CC = qcv(terms="1, 11, 15:20"),
    DD = qcv(terms="")
)


(x <- cm_range2long(foo))
(z <- cm_range2long(foo, foo2, v.name="time"))
cm_code.exclude(x, list(ABnoC=qcv(AA, BB, CC)))
cm_code.exclude(z, list(ABnoC=qcv(AA, BB, CC)), rm.var="time")
excludes <- list(AnoB=qcv(AA, BB), ABnoC=qcv(AA, BB, CC))
(a <- cm_code.exclude(z, excludes, rm.var="time"))
plot(a)

#WITH cm_time2long
x <- list(
    transcript_time_span = qcv(00:00 - 1:12:00),
    A = qcv(terms = "2.40:3.00, 5.01, 6.02:7.00, 9.00"),
    B = qcv(terms = "2.40, 3.01:3.02, 5.01, 6.02:7.00, 9.00,
        1.12.00:1.19.01"),
    C = qcv(terms = "2.40:3.00, 5.01, 6.02:7.00, 9.00, 17.01")
)

y <- list(
    transcript_time_span = qcv(00:00 - 1:12:00),
    A = qcv(terms = "2.40:3.00, 5.01, 6.02:7.00, 9.00"),
    B = qcv(terms = "2.40, 3.01:3.02, 5.01, 6.02:7.00, 9.00,
        1.12.00:1.19.01"),
    C = qcv(terms = "2.40:3.00, 5.01, 6.02:7.00, 9.00, 17.01")
)

dat <- cm_time2long(x, y)
head(dat, 10)
cm_code.exclude(dat, list(P=qcv(A, B), Q=qcv(B, C), R=qcv(A, B, C)),
    rm.var = "variable")
}
}
\seealso{
\code{\link[qdap]{cm_range2long}},
\code{\link[qdap]{cm_time2long}},
\code{\link[qdap]{cm_df2long}},
\code{\link[qdap]{cm_code.blank}},
\code{\link[qdap]{cm_code.combine}},
\code{\link[qdap]{cm_code.overlap}},
\code{\link[qdap]{cm_code.transform}}
}
\keyword{co-occurrence}

