\name{potential_NA}
\alias{potential_NA}
\title{Search for Potential Missing Values}
\usage{
potential_NA(text.var, n = 3)
}
\arguments{
  \item{text.var}{The text variable.}

  \item{n}{Number of characters to consider for missing
  (default is 3).}
}
\value{
Returns a dataframe of potential missing values row numbers
and text.
}
\description{
Search for potential missing values (i.e., sentences that
are merely a punctuation mark) and optionally replace with
missing value (\code{NA}). Useful in the initial cleaning
process.
}
\examples{
\dontrun{
DATA$state[c(3, 7)] <- "."
potential_NA(DATA$state, 20)
potential_NA(DATA$state)
# USE TO SELCTIVELY REPLACE CELLS WITH MISSING VALUES
DATA$state[potential_NA(DATA$state, 20)$row[-c(3)]] <- NA
DATA
DATA <- qdap::DATA
}
}

