% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/npqcs.Q.r
\name{npqcs.Q}
\alias{npqcs.Q}
\alias{npqcs.Q.default}
\alias{npqcs.Q.npqcd}
\title{Function to plot the Q chart}
\usage{
npqcs.Q(x, ...)

\method{npqcs.Q}{default}(
  x,
  G,
  data.name = NULL,
  limits = NULL,
  method = c("Tukey", "Liu", "Mahalanobis", "RP", "LD"),
  alpha = 0.01,
  plot = FALSE,
  ...
)

\method{npqcs.Q}{npqcd}(
  x,
  data.name,
  limits = NULL,
  method = c("Tukey", "Liu", "Mahalanobis", "RP", "LD"),
  alpha = 0.01,
  plot = FALSE,
  ...
)
}
\arguments{
\item{x}{An object npqcd (Non parametric Quality Control Data)}

\item{...}{arguments passed to or from methods.}

\item{G}{The x as a matrix, data frame or list. If it is a matrix or data frame, then each row is viewed as one multivariate observation.}

\item{data.name}{a string that specifies the title displayed on the plots. 
If not provided it is taken from the name of the object x.}

\item{limits}{a two-value vector specifying the control limits lower and central.}

\item{method}{Character string which determines the depth function used. 
method can be "Tukey" (the default), "Liu", "Mahalanobis", "RP" Random Project or "LD" Likelihood depth.}

\item{alpha}{it is the the significance level (0.01 for default)}

\item{plot}{a logical value indicating it should be plotted.}
}
\description{
This function is used to compute statistics required by the Q chart.
}
\examples{
\dontrun{ 
##
##  Continuous data 
##
library(qcr)
set.seed(12345)
mu<-c(0,0)
Sigma<- matrix(c(1,0,0,1),nrow = 2,ncol = 2)
u <- c(2,2)
S <- matrix(c(4,0,0,4),nrow = 2,ncol = 2)
G <- rmvnorm(540, mean = mu, sigma = Sigma)
x<- rmvnorm(40,mean=u,sigma = S)
x <- rbind(G[501:540,],x)
n <- 4 # samples
m <- 20  # measurements
k <- 2  # number of variables
x.a <- array(,dim=c(n,k,m))
for (i in 1:m){
x.a[,,i] <- x[(1+(i-1)*n):(i*n),] }
M <- G[1:500,]
data.npqcd <- npqcd(x.a,M)
str(data.npqcd)
res.npqcs <- npqcs.Q(data.npqcd,method = "Liu", alpha=0.025)
str(res.npqcs)
summary(res.npqcs)
plot(res.npqcs,title =" Q Control Chart")}
}
\references{
Regina Liu (1995)
}
