% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/04_assessment.R
\name{assessment}
\alias{assessment}
\title{Assessment measures of quantile composite-based path modeling}
\usage{
assessment(qcpm)
}
\arguments{
\item{qcpm}{is an  is an object of class \code{qcpm}}
}
\value{
\item{Communality}{Communality of each MV. It is the proportion of the MV’ 
variance explained by the corresponding construct.}

\item{Block_Communality}{Communality of a whole block. It is computed 
as the average of the MV communalities belonging to that block.}

\item{Redundancy}{Redundancy of each MV of the endogenous blocks. It measures 
the percent of the variance of MVs in endogenous blocks that is predicted from the 
explanatory constructs related to the endogenous construct.}

\item{Block_Redundancy}{Redundancy of a block. It is computed as the average of 
the MV redundancies belonging to that block.}

\item{pseudo.R2}{The pseudo—R2. It assesses the goodness of fit of the inner 
model.}
}
\description{
\code{assessment} returns the following measures for assessing both the inner 
and the outer model: communality of each manifest variable, communality of 
each block,redundancy of each manifest variable of endogenous blocks, redundancy 
of the endogenous blocks and pseudo-R2 for each inner equation.
}
\details{
All the assessment measures, discussed in Davino et al. (2016) and Dolce et al (2021), 
are based on the pseudo-R2, proposed by Koenker and Machado (1999), which simulates 
the role and interpretation of the R2 in classical regression analysis. The pseudo-R2 
is considered as a local measure of goodness of fit for a particular quantile as it 
measures the contribute of the selected regressors to the explanation of the dependent 
variable with respect to the trivial model without regressors. In more technical way, 
pseudo-R2 compares the residual absolute sum of weighted differences using the selected 
model with the total absolute sum of weighted differences using a model with the only 
intercept. The pseudo—R2 can be used to assess the inner model measuring the amount of 
variability of a given endogenous construct explained by its explanatory constructs. A 
synthesis of the evaluations regarding the whole inner model can be obtained by the 
average of all the pseudo—R2. Communality indicates how much of the MV variance is 
explained by the corresponding construct. It can be calculated for each MV, and for 
a block, using the average of each the MV communality. Redundancy measures the percent 
of the variance of MVs in an endogenous block that is predicted from the explanatory 
constructs related to the endogenous construct. Redundancy can be computed only for 
each MVs of endogenous blocks and for the whole endogenous blocks, using the average 
of the MV redundancies. Results are provided for each quantile of interest. When 
\code{qcpm} parameter \code{fix.quantile}, the function returns communalities only 
for the quantile 0.5.
}
\examples{

# Example of QC-PM in Well-Being analysis
# model with three LVs and reflective indicators

# load library and dataset province
library(qcpm)
data(province)

# Define the model using laavan sintax. Use a set of regression formulas defining 
# firstly the structural model and then the measurement model
model <- "
# Structural model
EcoW ~ Edu
Health ~ Edu + EcoW

# Reflective measurement model
Edu =~ O22 + O23 + O24 + O25aa + O26 + O_27_28 + O_27_28_AA
EcoW =~ O41 + O44aa + O45 + O46aa + O42 + O43
Health =~  O11F + O11M + O12MEAN_aa
"

# Apply qcpm
well.qcpm = qcpm(model,province)
well.assessment = assessment(well.qcpm)   
well.assessment 

}
\references{
Davino, C., Dolce, P., Taralli, S., Vistocco, D. (2020)  Composite-Based Path 
Modeling for Conditional Quantiles Prediction. An Application to Assess 
Health Differences at Local Level in a Well-Being Perspective. 
\emph{Social Indicator Research}, pp. 1-30, doi:10.1007/s11205-020-02425-5.

Davino, C., Vinzi, V.E. (2016) Quantile composite-based path
modeling. \emph{Advansed Data Analysis and Classification}, \bold{10}, pp. 
491–520, doi:10.1007/s11634-015-0231-9.

Davino C., Esposito Vinzi V., Dolce P. (2016) Assessment and validation in 
quantile composite-based path modeling. In: Abdi H., Esposito Vinzi V., Russolillo G., 
Saporta G., Trinchera L. (eds) The Multiple facets of partial least squares methods, 
chapter 13. Springer proceedings in mathematics and statistics. Springer, Berlin

Dolce, P., Davino, C., Vistocco, D. (2021) Quantile composite-based path modeling: 
algorithms, properties and applications.\emph{Advansed Data Analysis and Classification},
doi:10.1007/s11634-021-00469-0.

Koenker R, Machado J.A.F. (1999) Goodness of fit and related inference processes for quantile 
regression. \emph{Journal of the American Statistical Association}, \bold{94(448)} pp.1296–1310
doi: 10.1080/01621459.1999.10473882

He X.M., Zhu L.X. (2003) A lack-of-fit test for quantile regression. 
\emph{Journal of the American Statistical Association} \bold{98} pp.1013–1022 
doi: 10.1198/016214503000000963
}
\seealso{
\code{\link{summary}}, \code{\link{qcpm}}, \code{\link{boot}}, and 
\code{\link{reliability}}
}
\author{
Cristina Davino, Pasquale Dolce, Giuseppe Lamberti, Domenico Vistocco
}
