\name{smoothIRSolid}
\alias{smoothIRSolid}
%- Also NEED an '\alias' for EACH other topic documented here.
\title{
Smooth object generated by function \code{estimateIRsolid}
}
\description{
Adaptive smoothing of Rx and Sx maps over WM and GM areas.
}
\usage{
smoothIRSolid(IRmixedobj, kstar = 24, patchsize = 1, alpha = 0.025,
                   mscbw = 5, bysegment=TRUE, partial=TRUE, verbose=TRUE)
}
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{IRmixedobj}{
   object of class \code{IRmixed} generated by function \code{estimateIRsolid}
}
  \item{kstar}{
   number of steps for AWS algorithm
}
  \item{patchsize}{
   patchsize in paws
}
  \item{alpha}{
   significance level for decisions in aws algorithm (suggestion: between 1e-5 and 0.025)
}
  \item{mscbw}{
   bandwidth for 3D median smoother used to stabilize the covariance estimates.
}
   \item{bysegment}{
   \code{TRUE}: restrict smoothing to segments from segmentation, \code{FALSE}: restrict smoothing to solid mask.
}
   \item{partial}{
   \code{TRUE}: ignore information concerning parameter \code{fx} when smoothing.  
}
 \item{verbose}{
   logical: Monitor process.
}
}
\details{
  This uses a vectorized version of the AWS algorithm that emloys inverse covariance estimates of the estimated parameters. Local smoothing is done for Rx and Sx maps in ergs which can be assumed to be locally smooth within tissue. No smoothing for fx maps since they may vary.
}
\value{
an object of class \code{"IRmixed"}, but with components Sx and Rx replaced. The object carries an additional component \code{bi} containing an array of sum of weights characterizing the amount of smoothing.
}
\author{
Karsten Tabelow \email{tabelow@wias-berlin.de}\cr
J\"org Polzehl \email{polzehl@wias-berlin.de}
}

\seealso{
 \code{\link{estimateIRfluid}}, \code{\link{estimateIRsolid}}, \code{\link{estimateIRsolidfixed}},\code{\link{estimateIR}}
}
\examples{
##---- Should be DIRECTLY executable !! ----
##-- ==>  Define data, use random,
##--	or do  help(data=index)  for the standard data sets.

## The function is currently defined as
function (ergs, segm, kstar = 24, ladjust = 1)
{
    mask <- segm > 1
    nvoxel <- sum(mask)
    bpars <- array(0, c(2, nvoxel))
    icovbpars <- array(0, c(2, 2, nvoxel))
    bpars[1, ] <- ergs$Rx[mask]
    bpars[2, ] <- ergs$Sx[mask]
    ICovx <- ergs$ICovx
    dim(ICovx) <- c(3, 3, prod(dim(mask)))
    icovbpars <- ICovx[-1, -1, mask]
    z <- vpawscov2(bpars, kstar, icovbpars/ladjust, segm > 1)
    ergs$Rx[mask] <- z$theta[1, ]
    ergs$Sx[mask] <- z$theta[2, ]
    bi <- array(0, dim(mask))
    bi[mask] <- z$bi
    ergs$bi <- bi
    ergs
  }
}
% Add one or more standard keywords, see file 'KEYWORDS' in the
% R documentation directory (show via RShowDoc("KEYWORDS")):
 \keyword{ utilities }
 \keyword{ smooth }
% Use only one keyword per line.
% For non-standard keywords, use \concept instead of \keyword:
 \concept{ IRMRI }
% \concept{ ~cpt1 }
% \concept{ ~cpt2 }
% Use only one concept per line.
