% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/pystr_splitlines.R
\name{pystr_splitlines}
\alias{pystr_splitlines}
\title{Split a string at linebreaks.}
\usage{
pystr_splitlines(str, keepends = FALSE)
}
\arguments{
\item{str}{A character vector.}

\item{keepends}{A logical vector.}
}
\value{
A list of character vectors.
}
\description{
Return a list of the lines in the string, breaking at line boundaries.
}
\details{
Line breaks are not included in the resulting list unless \code{keepends} is
\code{TRUE}. Line breaks include \code{"\n"}, \code{"\r"}, and \code{"\r\n"}.
}
\examples{
pystr_splitlines("First\\nSecond\\rThird\\r\\n")
pystr_splitlines("First\\nSecond\\rThird\\r\\n", TRUE)
}
\references{
\url{https://docs.python.org/3/library/stdtypes.html#str.splitlines}
}
\seealso{
\code{\link{pystr_split}}
}

