% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GetQualificationRequests.R
\name{GetQualificationRequests}
\alias{GetQualificationRequests}
\alias{ListQualificationRequests}
\alias{qualrequests}
\title{Get Qualification Requests}
\usage{
GetQualificationRequests(qual = NULL, results = as.integer(100),
  pagetoken = NULL, verbose = getOption("pyMTurkR.verbose", TRUE))
}
\arguments{
\item{qual}{An optional character string containing a QualificationTypeId to
which the search should be restricted. If none is supplied, requests made
for all QualificationTypes are returned.}

\item{results}{An optional character string indicating how many results to
fetch per page. Must be between 1 and 100. Most users can ignore this.}

\item{pagetoken}{An optional character string indicating which page of
search results to start at. Most users can ignore this.}

\item{verbose}{Optionally print the results of the API request to the
standard output. Default is taken from \code{getOption('pyMTurkR.verbose',
TRUE)}.}
}
\value{
A data frame containing the QualificationRequestId, WorkerId, and
other information (e.g., Qualification Test results) for each request.
}
\description{
Retrieve workers' requests for a QualificationType.
}
\details{
A function to retrieve pending Qualification Requests made by workers,
either for a specified QualificationType or all QualificationTypes.
Specifically, all active, custom QualificationTypes are visible to workers,
and workers can request a QualificationType (e.g., when a HIT requires one
they do not have). This function retrieves those requests so that they can
be granted (with \code{\link{GrantQualification}}) or rejected (with
\code{\link{RejectQualification}}).

\code{qualrequests()} and \code{ListQualificationRequests()} are aliases.
}
\examples{

\dontrun{
GetQualificationRequests()

# Search for qualifications you own, then get requests for one of the quals
SearchQualificationTypes(must.be.owner = TRUE, verbose = FALSE) -> quals
quals$QualificationTypeId[[1]] -> qual1
GetQualificationRequests(qual1)
}

}
\references{
\href{https://docs.aws.amazon.com/AWSMechTurk/latest/AWSMturkAPI/ApiReference_ListQualificationRequestsOperation.html}{API Reference}
}
\seealso{
\code{\link{GrantQualification}}

\code{\link{RejectQualification}}
}
\author{
Tyler Burleigh, Thomas J. Leeper
}
\keyword{Qualifications}
